# -*- coding: utf-8 -*-
"""
web2ldapcnf/misc.py - Misc. configuration options for web2ldap
(c) by Michael Stroeder <michael@stroeder.com>
"""

# Leave this alone
import os,web2ldapcnf

# A list with directories containing additional Python modules
pylibdirs = [os.path.join(web2ldapcnf.web2ldap_dir,'pylib')]

########################################################################
# HTTP-Options
########################################################################

# The HTTP body can be sent to client gzip-compressed if client presents
# gzip in HTTP_ACCEPT_ENCODING. You can set the gzip level (1-9) here.
# Set 0 to turn it off. This needs zlibmodule which is automatically detected.
# Note: This might speed things up if the server's CPU is very fast
# compared to the network link. Even with large search results you
# won't gain much by choosing gzip level higher than 1.
# Note: Seems to break displaying images in-line in Netscape 4.x.
gzip_level=0

########################################################################
# Other Options
########################################################################

# Trace output of the LDAP connection can be written to error
# output (if not started with python -O).
# Set to non-zero if you want debug your LDAP connection.
# Warning! Passwords (credentials) are written to this trace log!
# If unsure leave zero! Only set to non-zero if you have protected logs!
ldap_trace_level = 0

# If non-zero this turns on debug output of the OpenLDAP libs.
# Warning! Confidential information might be disclosed to the log!
# If unsure leave zero! Only set to non-zero if you have protected logs!
ldap_opt_debug_level = 0

# Maximum length of LDIF data in the <TEXTAREA> of addform/modifyform
ldif_maxbytes = 200000

# List of URL schemes to process in LDIF input.
# !!! Beware, this can be a security nightmare! Think twice!
# If unsure leave as empty list to ignore all URLs in LDIF.
ldif_url_schemes = []

# Maximum count of input attribute fields in addform/modifyform
input_maxattrs=3000

# Maximum length of attribute values in input fields in addform/modifyform
input_maxfieldlen=6000

# Maximum count of input attribute fields in addform/modifyform
input_maxbinattrs=50

# Maximum length of attribute data uploaded from file
input_maxfilelen=200000

# maximum count of search parameters in a search form
max_searchparams=20

# Path name to dumpasn1.cfg. Grab it from
# http://www.cs.auckland.ac.nz/~pgut001/dumpasn1.cfg
dumpasn1cfg = os.path.join(web2ldapcnf.etc_dir,'dumpasn1.cfg')

########################################################################
# Global HTML templates
########################################################################

# Template covering doctype, complete <head> section and opening <body>
html_begin_template = os.path.join(web2ldapcnf.templates_dir,'html_begin.html')

# Template for initial connect dialogue
connect_template = os.path.join(web2ldapcnf.templates_dir,'connect.html')

########################################################################
# Security options
########################################################################

# Maximum number of concurrent web sessions stored
session_limit = 20

# Amount of time in seconds after which inactive sessions will be expired
# and the session data is removed silently without the possibility to relogin.
session_remove = 7200

# List of environment variables assumed to be constant throughout
# web sessions with the same ID if existent.
# These env vars are cross-checked each time when restoring an
# web session to reduce the risk of session-hijacking.
session_checkvars = (
  # REMOTE_ADDR and REMOTE_HOST might not be constant if the client
  # access comes through a network of web proxy siblings.
  'REMOTE_ADDR','REMOTE_HOST',
  'REMOTE_IDENT','REMOTE_USER',
  # If the proxy sets them but can be easily spoofed
  'FORWARDED_FOR','HTTP_X_FORWARDED_FOR',
  # These few are not really secure but better than nothing
  'HTTP_USER_AGENT','HTTP_ACCEPT_CHARSET',
  'HTTP_ACCEPT_ENCODING','HTTP_ACCEPT_LANGUAGE',
  # SSL parameters negotiated within a SSL connection
  'SSL_CIPHER_ALGKEYSIZE','HTTPS_KEYSIZE','SSL_KEYSIZE','SSL_SERVER_KEY_SIZE',
  'SSL_CIPHER_EXPORT','HTTPS_EXPORT','SSL_EXPORT',
  'SSL_CIPHER','HTTPS_CIPHER',
  'SSL_CIPHER_USEKEYSIZE','HTTPS_SECRETKEYSIZE','SSL_SECKEYSIZE',
  # SSL session ID if running on SSL server capable
  # of reusing SSL sessions (needs server configuration)
#  'SSL_SESSION_ID',
  # env vars of client certs used for SSL strong authentication
  'SSL_CLIENT_V_START','SSL_CLIENT_V_END',
  'SSL_CLIENT_I_DN','SSL_CLIENT_IDN',
  'SSL_CLIENT_S_DN','SSL_CLIENT_SDN',
  'SSL_CLIENT_M_SERIAL','SSL_CLIENT_CERT_SERIAL',
)

# If non-zero or True there's a new session ID generated for each hit.
# Disadvantage: The browser's back button does not work anymore.
session_paranoid = 0

# You can set sec_expire to define the amount of
# time (in seconds) the data is valid in the browser
# (HTTP header Expires: is set).
# Note that if you're doing modifications you might get
# a very nasty behaviour if the pages are cached by your browser.
sec_expire = 0

# Specifies a list of the acceptable symmetric key ciphers to
# reach security level 1.
# See also http://www.apache-ssl.org/docs.html and the ApacheSSL
# run-time directives SSLBanCipher, SSLRequireCipher, SSLRequiredCiphers
# Does currently not affect stand-alone mode with SSL.
sec_sslacceptedciphers = (
# Strong ciphers
    'IDEA-CBC-SHA',
    'RC4-MD5',
    'RC4-SHA',
    'IDEA-CBC-MD5',
    'DES-CBC3-SHA',
    'DH-DSS-DES-CBC3-SHA',
    'DH-RSA-DES-CBC3-SHA',
    'EDH-DSS-DES-CBC3-SHA',
    'EDH-RSA-DES-CBC3-SHA',
    'ADH-RC4-MD5',
    'ADH-DES-CBC3-SHA',
    'FZA-RC4-SHA',
    'RC2-CBC-MD5',
    'DES-CBC3-MD5',
    'DHE-RSA-AES256-SHA',
    'AES128-SHA',
# Weak export ciphers
#    'EXP-RC4-MD5',
#    'EXP-RC2-CBC-MD5',
#    'EXP-DES-CBC-SHA',
#    'DES-CBC-SHA',
#    'EXP-DH-DSS-DES-CBC-SHA',
#    'DH-DSS-DES-CBC-SHA',
#    'EXP-DH-RSA-DES-CBC-SHA',
#    'DH-RSA-DES-CBC-SHA',
#    'EXP-EDH-DSS-DES-CBC-SHA',
#    'EDH-DSS-DES-CBC-SHA',
#    'EXP-EDH-RSA-DES-CBC',
#    'EDH-RSA-DES-CBC-SHA',
#    'EXP-ADH-RC4-MD5',
#    'EXP-ADH-DES-CBC-SHA',
#    'ADH-DES-CBC-SHA',
#    'DES-CFB-M1',
#    'DES-CBC-MD5',
#    'RC4-64-MD5'
  )
