#!/usr/bin/perl
#
# spmpp - Util scrip to generate a Config::General message catalog
#         for use in the Validator, from an OpenSP ParserMessages.rc.
#         (spmpp = "SP Message Pre-Processor")
#
# $Id: spmpp.pl,v 1.1.2.2 2003/07/26 16:05:55 ville Exp $
#

#
# Require Perl 5.6.1
require 5.006_1;

#
# Keep myself from making stupid mistakes.
use strict;
use warnings;

#
# Array to keep messages in.
my @msg;

#
# Snarf OpenSP's ParserMessages.rc and populate @msg.
my $msgfile = $ARGV[0] || "/usr/local/validator/htdocs/config/verbosemsg.rc";
open FH, $msgfile
  or die "Can't open OpenSP ParserMessages file '$msgfile': $!";
while (<FH>) {
  next if /^\s*$/;
  my($id, $s) = split /, /, $_, 2;
  $id += 0; # Force numerical (kill leading space)...
  chomp $s; # Strip newline from end of message...
  push @msg, [$id, $s];
}
close FH;

print <<".EOF.";
#
# Automatically Generated by $0
#

.EOF.

#
# For each message, spit out a Config::General config file snippet.
#
# The stuff in "verbose" needs to be a complete XHTML 1.0 Strict
# block level element (e.g. a single DIV, or a DIV containing
# multiple Ps; not multiple Ps without a container). The @class
# and @id are used to play tricks with JavaScript in the final
# output. "mid-n" identifies the class of message, "muid-n-n"
# identifies the specific instance of that message (which is why
# the last digit of the "muid" is replaced at runtime).
#
for (@msg) {
  print <<"_.EOF._";
<msg $_->[0]>
  original = $_->[1]
  verbose <<.EOF.
  <div class="ve mid-$_->[0]">
    <p class="helpwanted">
      <em>Help Wanted!</em> This message (#$_->[0]) has no explanation yet.
      If you can think of a succinct way to explain the possible situations
      that will trigger this error and how to fix it, please consider writing
      it down and sending it to the <a
        href="mailto:www-validator\@w3.org?Subject=[VE][$_->[0]]%20New%20Error%20Message%20Suggestion"
      >www-validator\@w3.org</a> list.
    </p>
  </div>
.EOF.
</msg>
_.EOF._
}

exit;
