"""
test_exploit.py

Copyright 2013 Andres Riancho

This file is part of w3af, http://w3af.org/ .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""
import os

from w3af.core.ui.tests.gui import GUI_TEST_ROOT_PATH
from w3af.core.ui.tests.wrappers.xpresser_unittest import XpresserUnittest


class TestExploit(XpresserUnittest):
    
    IMAGES = os.path.join(GUI_TEST_ROOT_PATH, 'exploit', 'images')
    TARGET = 'http://moth/w3af/audit/sql_injection/select/sql_injection_integer.php?id=1'
    
    def setUp(self):
        super(TestExploit, self).setUp()
    
    def test_scan_exploit(self):
        # Enable all audit plugins
        self.click('audit_plugin_checkbox')
        
        self.click('insert_target_url_here')
        self.type(self.TARGET, False)
        self.type(['<Enter>',], False)

        self.find('log_tab_enabled')
        self.find('sql_mysql', 25)
        # Wait for the scan to finish
        self.find('clear_icon', 20)
        
        self.click('exploit_tab')
        
        self.right_click('sqlmap')
        self.click('context_menu_exploit_until_first')
        
        self.find('multiple_exploit')
        #self.find('generated_shell')
        self.click('ok')
        
        self.double_click('shell_inst')
        
        self.find('shell_window_title')
        
        #FIXME: https://github.com/andresriancho/w3af/issues/228
        """ 
        self.sleep(1)
        self.type('dbs', False)
        self.type(['<Enter>',], False)
        self.find('wordpress', 15)
        """
        
        # Close the shell
        self.type(['<Alt>','<F4>'], False)
        