"""
utils.py

Copyright 2007 Andres Riancho

This file is part of w3af, http://w3af.org/ .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""
from w3af.core.ui.gui import entries
from w3af.core.ui.gui.output.message_consumer import MessageConsumer
from w3af.core.controllers.exceptions import BaseFrameworkException


def get_exploitable_vulns(exploit):
    """Returns the exploitable vulnerabilities.

    :param exploit: the exploit to search.
    """
    try:
        vulns = exploit.get_exploitable_vulns()
    except BaseFrameworkException:
        print "WARNING: The %r exploit has no get_exploitable_vulns method!" % exploit
        vulns = []
    return vulns


class TextDialogConsumer(entries.TextDialog, MessageConsumer):
    def __init__(self, title, tabnames=(), icon=None):
        entries.TextDialog.__init__(self, title, tabnames, icon)
        MessageConsumer.__init__(self)

    def handle_message(self, msg):
        # This yield True is required by MessageConsumer
        yield True
        
        if msg.get_type() == 'console':
            # Handling new lines
            text = msg.get_msg()
            if msg.get_new_line():
                text += '\n'
    
            self.add_message(text)

