"""
user_reports_bug.py

Copyright 2009 Andres Riancho

This file is part of w3af, w3af.org .

w3af is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation version 2 of the License.

w3af is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with w3af; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
import gtk

from w3af.core.ui.gui.exception_handling.common_windows import (
    SimpleBaseWindow, GithubBugReport)


class user_reports_bug(SimpleBaseWindow, GithubBugReport):
    """
    This window covers the STRANGE case in which a user goes to the Help menu
    and clicks on "Report Bug".
    """

    def __init__(self):
        SimpleBaseWindow.__init__(self)
        GithubBugReport.__init__(
            self, 'No traceback available on user bug report.')

        # We got here because of the user going to the Help menu and
        # then clicking on "Report a bug"
        self.autogen = False

        # Set generic window settings
        self.set_modal(True)
        self.set_title('Report bug to developers')

        self.vbox = gtk.VBox()
        self.vbox.set_border_width(10)

        # the label for the rest of the message
        self.label = gtk.Label()
        self.label.set_line_wrap(True)
        label_text = _(
            '<b>You can contribute</b> with the w3af project by submitting')
        label_text += _(' a bug report to our system using this window.')
        label_text += _(' It\'s a simple <i>two step process</i>.\n\n')
        label_text += _('w3af will only send the text you enter and the version information to')
        label_text += _(
            ' Github, no personal or confidential information is collected.\n')
        self.label.set_markup(label_text)
        self.label.show()

        hbox = gtk.HBox()
        icon = gtk.Image()
        icon.set_from_stock(gtk.STOCK_YES, gtk.ICON_SIZE_DIALOG)
        hbox.pack_start(icon, True, True, 30)
        hbox.pack_start(self.label, True, True)

        self.vbox.pack_start(hbox, True, True)

        # the buttons
        self.hbox = gtk.HBox()
        self.butt_cancel = gtk.Button(stock=gtk.STOCK_CANCEL)
        self.butt_cancel.connect("clicked", self._handle_cancel)
        self.hbox.pack_start(self.butt_cancel, True, False)

        self.butt_send = gtk.Button(stock=gtk.STOCK_OK)
        self.butt_send.connect("clicked", self.report_bug)
        self.hbox.pack_start(self.butt_send, True, False)

        self.vbox.pack_start(self.hbox, True, False)

        #self.resize(400,450)
        self.add(self.vbox)
        self.show_all()

        # This is a quick fix to get around the problem generated by "set_selectable"
        # that selects the text by default
        self.label.select_region(0, 0)

    def report_bug(self, widg):
        # Avoid "double clicking" in the OK button,
        self.butt_send.set_sensitive(False)

        # Report the bug
        GithubBugReport.report_bug(self)
