/* $Id: common.h,v 1.10 2002/10/30 19:27:09 bjk Exp $ */
/*
    Copyright (C) 2001-2002  Ben Kibbey <bjk@arbornet.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <pwd.h>
#include "config.h"

#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

#ifdef HAVE_ERR_H
#include <err.h>
#endif

#ifdef HAVE_PATHS_H
#include <paths.h>
#endif

#ifdef HAVE_KVM_H
#undef HAVE_PROCFS
#include <kvm.h>
#endif

#ifdef HAVE_LASTLOG_H
#include <lastlog.h>
#endif

#ifdef HAVE_UTMPX_H
#include <utmpx.h>
#ifndef UT_HOSTSIZE
#define UT_HOSTSIZE	257
#define UT_LINESIZE	32
#define UT_NAMESIZE	32
#endif

#define ut_name ut_user

#ifndef _NO_UT_TIME                                               
#define ut_time ut_tv.tv_sec                                      
#endif                                                            

#define ut_xtime ut_tv.tv_sec                                     
#define ut_addr ut_addr_v6[0] 

#ifdef UTMPX_FILE
#define _PATH_UTMP	UTMPX_FILE
#endif
#else
#include <utmp.h>
#ifndef UT_HOSTSIZE
#define UT_HOSTSIZE	16
#define UT_LINESIZE	8
#define UT_NAMESIZE	16
#endif

#ifdef UTMP_FILE
#define _PATH_UTMP	UTMP_FILE
#endif
#endif /* HAVE_UTMPX_H */

#ifdef HAVE_PROCFS
#include <dirent.h>
#endif

#ifdef HAVE_GETSPNAM
#include <shadow.h>
#endif

#ifdef HAVE_SYS_LIMITS_H
#include <sys/syslimits.h>
#endif

#ifndef LINE_MAX
#ifdef _POSIX2_LINE_MAX
#define LINE_MAX	_POSIX2_LINE_MAX
#elif defined(_POSIX_LINE_MAX)
#define LINE_MAX	_POSIX_LINE_MAX
#else
#define LINE_MAX	2048
#endif
#endif

#ifndef _PATH_LASTLOG
#define _PATH_LASTLOG	"/var/adm/lastlog"
#endif

#ifndef _PATH_DEV
#define _PATH_DEV	"/dev/"
#endif

#ifndef _PATH_MAILDIR
#define _PATH_MAILDIR	"/var/mail"
#endif

#define 		ARRAYCNT(x) (sizeof x / sizeof(x[0]))
#define MAXOPTIONS	64
#define TIMEBUFSIZE	64

/* structure definitions */
typedef struct gecos {
    char *name;
    char *office;
    char *officephone;
    char *homephone;
} GECOS;

typedef struct mails {
    char lastread[TIMEBUFSIZE];
    char newstamp[TIMEBUFSIZE];
    off_t foldersize;
    char forward[LINE_MAX];
    char aliases[LINE_MAX];
} MAIL;

typedef struct lastinfo {
    char tty[UT_LINESIZE + 1];
    char host[UT_HOSTSIZE + 1];
    char time[TIMEBUFSIZE];
} LASTINFO;

typedef struct logins {
    char stamp[TIMEBUFSIZE];
    int duration;
    char host[UT_HOSTSIZE + 1];
    char tty[UT_LINESIZE + 1];
    int idle;
    pid_t ppid;
    unsigned mesgstat;
    unsigned online;
} LOGIN;

typedef struct groups {
    gid_t id;
    char name[LINE_MAX];
    struct groups *next;
} GROUP;

typedef struct infos {
    struct passwd *passwd;
#ifdef HAVE_GETSPNAM
    struct spwd *spwd;
#endif
    GROUP *group;
    GECOS *gecos;
    LASTINFO *lastinfo;
    MAIL *mail;
    LOGIN *login;
} INFO;

/* external variables */
unsigned verbose, delimchar, group_info, usefile;
int optspec[MAXOPTIONS];
char *__progname, *gecosopts, *lastopts, tf[TIMEBUFSIZE];
char *aliasbuf;
int aliasfd, utmpfd, lastlogfd;
#ifdef HAVE_PROCFS
DIR *procdir;
#endif
#ifdef HAVE_GETSPNAM
int amroot;
#endif
#ifdef HAVE_KVM_H
kvm_t *kd;
#endif

/* function prototypes */
char *stripstr(char *, char *);
char *stamp(time_t, const char *);
void *Malloc(size_t);
void *Calloc(size_t, size_t);

#ifndef HAVE_ERR_H
void warn(const char *fmt, ...);
void warnx(const char *fmt, ...);
void errx(int eval, const char *fmt, ...);
void err(int eval, const char *fmt, ...);
#endif

#ifndef HAVE_STRSEP
char *strsep(char **, const char *);
#endif
