/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#include "AMT_EventSubscriber.h"
using namespace CimClassNamespace;

AMT_EventSubscriber::RequestStateChange_INPUT::RequestStateChange_INPUT()
	:Serializable("RequestStateChange_INPUT", AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX),
	RequestedStateSpecified(false),
	TimeoutPeriodSpecified(false){}

void AMT_EventSubscriber::RequestStateChange_INPUT::SerializeMembers(XMLElement& node) const
{
	if(RequestedStateSpecified)
	{
		node.AppendLeaf("RequestedState", RequestedState, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(TimeoutPeriodSpecified)
	{
		node.AppendLeaf("TimeoutPeriod", TimeoutPeriod, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
}

AMT_EventSubscriber::RequestStateChange_OUTPUT::RequestStateChange_OUTPUT()
	:DeSerializable("RequestStateChange_OUTPUT",AMT_EventSubscriber::CLASS_URI),
	JobSpecified(false){}

void AMT_EventSubscriber::RequestStateChange_OUTPUT::SetValue(const XMLElement& node)
{
	string name = node.GetNodeName();
	if(name == "Job")
	{
		node.SetComplexType(Job);
		JobSpecified = true;
	}
	else if(name == "ReturnValue")
	{
		node.SetValue(ReturnValue);
	}
}

AMT_EventSubscriber::AMT_EventSubscriber(
		const string& objName,
		const string& uri,
		const string& ns,
		const string& nsPrefix)
		:CIM_RemotePort(objName, uri, ns, nsPrefix){}

void  AMT_EventSubscriber::SerializeMembers(XMLElement& node) const
{
	if(AccessInfoSpecified)
	{
		node.AppendLeaf("AccessInfo", AccessInfo, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(CaptionSpecified)
	{
		node.AppendLeaf("Caption", Caption, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("CreationClassName", CreationClassName, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	if(DescriptionSpecified)
	{
		node.AppendLeaf("Description", Description, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(ElementNameSpecified)
	{
		node.AppendLeaf("ElementName", ElementName, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(EnabledDefaultSpecified)
	{
		node.AppendLeaf("EnabledDefault", EnabledDefault, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(EnabledStateSpecified)
	{
		node.AppendLeaf("EnabledState", EnabledState, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(HealthStateSpecified)
	{
		node.AppendLeaf("HealthState", HealthState, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(InfoFormatSpecified)
	{
		node.AppendLeaf("InfoFormat", InfoFormat, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(InstallDateSpecified)
	{
		node.AppendLeaf("InstallDate", InstallDate, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("Name", Name, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	node.AppendLeafArray("OperationalStatus", OperationalStatus, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	if(OtherEnabledStateSpecified)
	{
		node.AppendLeaf("OtherEnabledState", OtherEnabledState, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(OtherInfoFormatDescriptionSpecified)
	{
		node.AppendLeaf("OtherInfoFormatDescription", OtherInfoFormatDescription, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(OtherProtocolDescriptionSpecified)
	{
		node.AppendLeaf("OtherProtocolDescription", OtherProtocolDescription, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(PortInfoSpecified)
	{
		node.AppendLeaf("PortInfo", PortInfo, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(PortProtocolSpecified)
	{
		node.AppendLeaf("PortProtocol", PortProtocol, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(RequestedStateSpecified)
	{
		node.AppendLeaf("RequestedState", RequestedState, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	if(StatusSpecified)
	{
		node.AppendLeaf("Status", Status, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
	node.AppendLeafArray("StatusDescriptions", StatusDescriptions, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	node.AppendLeaf("SystemCreationClassName", SystemCreationClassName, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	node.AppendLeaf("SystemName", SystemName, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	if(TimeOfLastStateChangeSpecified)
	{
		node.AppendLeaf("TimeOfLastStateChange", TimeOfLastStateChange, AMT_EventSubscriber::CLASS_URI, AMT_EventSubscriber::CLASS_NS_PREFIX);
	}
}

NameValuePairs AMT_EventSubscriber::GetSelectorsList() const
{
	NameValuePairs serList;
	serList["CreationClassName"] = XMLTypeConverter::TypeToString(CreationClassName);
	serList["Name"] = XMLTypeConverter::TypeToString(Name);
	serList["SystemCreationClassName"] = XMLTypeConverter::TypeToString(SystemCreationClassName);
	serList["SystemName"] = XMLTypeConverter::TypeToString(SystemName);
	return serList;
}

void AMT_EventSubscriber::SetValue(const XMLElement& node)
{
	string name = node.GetNodeName();
	if(name == "OtherProtocolDescription")
	{
		node.SetValue(OtherProtocolDescription);
		OtherProtocolDescriptionSpecified = true;
	}
	else if(name == "PortProtocol")
	{
		node.SetValue(PortProtocol);
		PortProtocolSpecified = true;
	}
	else if(name == "PortInfo")
	{
		node.SetValue(PortInfo);
		PortInfoSpecified = true;
	}
	else if(name == "Name")
	{
		node.SetValue(Name);
	}
	else if(name == "CreationClassName")
	{
		node.SetValue(CreationClassName);
	}
	else if(name == "SystemName")
	{
		node.SetValue(SystemName);
	}
	else if(name == "SystemCreationClassName")
	{
		node.SetValue(SystemCreationClassName);
	}
	else if(name == "ElementName")
	{
		node.SetValue(ElementName);
		ElementNameSpecified = true;
	}
	else if(name == "Description")
	{
		node.SetValue(Description);
		DescriptionSpecified = true;
	}
	else if(name == "Caption")
	{
		node.SetValue(Caption);
		CaptionSpecified = true;
	}
	else if(name == "InstallDate")
	{
		node.SetValue(InstallDate);
		InstallDateSpecified = true;
	}
	else if(name == "OperationalStatus")
	{
		node.AddValue(OperationalStatus);
	}
	else if(name == "StatusDescriptions")
	{
		node.AddValue(StatusDescriptions);
	}
	else if(name == "Status")
	{
		node.SetValue(Status);
		StatusSpecified = true;
	}
	else if(name == "HealthState")
	{
		node.SetValue(HealthState);
		HealthStateSpecified = true;
	}
	else if(name == "EnabledState")
	{
		node.SetValue(EnabledState);
		EnabledStateSpecified = true;
	}
	else if(name == "OtherEnabledState")
	{
		node.SetValue(OtherEnabledState);
		OtherEnabledStateSpecified = true;
	}
	else if(name == "RequestedState")
	{
		node.SetValue(RequestedState);
		RequestedStateSpecified = true;
	}
	else if(name == "EnabledDefault")
	{
		node.SetValue(EnabledDefault);
		EnabledDefaultSpecified = true;
	}
	else if(name == "TimeOfLastStateChange")
	{
		node.SetValue(TimeOfLastStateChange);
		TimeOfLastStateChangeSpecified = true;
	}
	else if(name == "AccessInfo")
	{
		node.SetValue(AccessInfo);
		AccessInfoSpecified = true;
	}
	else if(name == "InfoFormat")
	{
		node.SetValue(InfoFormat);
		InfoFormatSpecified = true;
	}
	else if(name == "OtherInfoFormatDescription")
	{
		node.SetValue(OtherInfoFormatDescription);
		OtherInfoFormatDescriptionSpecified = true;
	}
}

void AMT_EventSubscriber::InvokeRequestStateChange(RequestStateChange_INPUT &input, RequestStateChange_OUTPUT &output, const WsmanClient *cl) const
{
	Invoke("RequestStateChange", &input, &output, cl);
}
const string AMT_EventSubscriber::CLASS_NAME = "AMT_EventSubscriber";
const string AMT_EventSubscriber::CLASS_URI = "http://intel.com/wbem/wscim/1/amt-schema/1/AMT_EventSubscriber";
const string AMT_EventSubscriber::CLASS_NS = "http://intel.com/wbem/wscim/1/amt-schema/1/AMT_EventSubscriber";
const string AMT_EventSubscriber::CLASS_NS_PREFIX = "";
