/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//*****************************************************************************
//
// Class:		UNSEventLogger
// Description:		EventLogger for User Notification Service.
//
//*****************************************************************************

#ifndef _UNS_EVENT_LOGGER_H
#define _UNS_EVENT_LOGGER_H

#include "BaseEventLog.h"
#include "Semaphore.h"
#include "Lock.h"

#ifdef _LINUX
	#include "EventMessages.h"
	#include "LinuxEventLog.h"
	#include "UNSMessageFileLinux.h"
#else
	#include "WindowsEventLog.h"
	#include "UNSMessageFile.h"
#endif

#define	EVENT_LOG_SOURCE_NAME		"Intel(R) AMT"
#define EVENT_LOG_LOG_NAME			"Application"
#define EVENT_LOG_MESSAGE_DLL_FILE	"%SystemRoot%\\system32\\UNSMsgs.dll"
#define EVENT_LOG_CATEGORY_COUNT	4

class UNSEventLogger
{
private:
	BaseEventLog *m_logger;
	Semaphore m_StateSemaphore;

	// Flags for events that were already logged.
	bool	m_SubscribeFail;
	bool	m_Subscribe;
	bool	m_GetFqdn;
	bool	m_Bind;
	bool	m_Cancel;
	bool	m_GetEACStatus;
	bool	m_GetPosture;
	bool	m_GetPostureHash;
	bool	m_WriteSharedData;
	bool	m_HECICommandFailed;
	bool	m_SetAMTStatusFailed;

public:
	UNSEventLogger();
	virtual ~UNSEventLogger();

	// Log information event by id and category
	void LogInfoEvent(unsigned short	CategoryID,
			  unsigned long		EventID);

	// Record service start message.
	void ServiceStart();

	// Record service stop message.
	void ServiceStopped();

	// Record subscription error message.
	void SubscriptionError();

	// Record subscription success message.
	void SubscriptionSuccess();

	// Record get net params (FQDN) error message.
	void GetFqdnFailure();

	// Record bind error message.
	void BindError();

	// Recored failed to cancel alert subscription.
	void CancelSubscriptionError();

	// Record failed to get EAC status error message.
	void GetEACStatusFailedError();

	// Record failed to get posture error
	void GetPostureFailedError();

	// Record failed to get posture hash error
	void GetPostureHashFailedError();

	//Record "failed to write shared posture/hash" error
	void WriteSharedDataError();

	/*Log messages for AMTStatus*/

	//Record "HECI Command failed" error
	void HECICommandFailedError();

	//Record "Failed to set AMT status" error
	void SetAMTStatusFailedError();

	// Record Events for debugging.
	void DebugLog(const char *message);

	// Record warning events
	void WarningLog(const char * message);

	// Record error events
	void ErrorLog(const char * message);

	// Reset all falgs
	void ResetFlags();
};

#endif // _UNS_EVENT_LOGGER_H
