/*
 * UnixCW - Unix CW (Morse code) training program
 * Copyright (C) 2001, 2002  Simon Baldwin (simonb@caldera.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * XcwcpApplication.h - Class header for Qt-based CW tutor program.
 *
 */

#ifndef XCWCP_H
#define XCWCP_H

#include <qmainwindow.h>

class	QKeyEvent;
class	QComboBox;
class	QSpinBox;
class	QToolButton;
class	QCheckBox;
class	QTimer;
class	XcwcpMultiLineEdit;

class XcwcpApplication: public QMainWindow
{
	Q_OBJECT
public:
	XcwcpApplication ();			/* Class constructor */
	~XcwcpApplication ();			/* Class destructor */
	void	key_event (QKeyEvent*);		/* Handle key press/release */
	void	mouse_event (QMouseEvent*);	/* Handle mouse press/release */

protected:
	void		closeEvent (QCloseEvent*);
						/* Close app callback */

private slots:
	/* Qt widget library callback methods. */
	void		about ();		/* About dialog */
	void		startstop ();		/* Start/stop sending toggle */
	void		start ();		/* Start sending */
	void		stop ();		/* Stop sending */
	void		new_xcwcp ();		/* Open a new window */
	void		clear ();		/* Clear the display window */
	void		sync_speed ();		/* Force adaptive speed */
	void		speed_change ();	/* Handle speed change */
	void		frequency_change ();	/* Handle tone change */
	void		volume_change ();	/* Handle volume change */
	void		gap_change ();		/* Handle gap change */
	void		mode_change ();		/* Handle mode change */
	void		curtis_mode_b_change ();/* Handle Curtis mode change */
	void		adaptive_receive_change ();
						/* Handle speed mode change */
	void		timer_event ();		/* Receive poll timeout call */

private:
	/* Class variable to enable sharing of the cwlib across instances. */
	static XcwcpApplication
			*cwlib_user_object_reference;
						/* 'this' of CW user instance */

	/* GUI elements used throughout the class. */
	QComboBox	*mode_combo;		/* Mode selector */
	QSpinBox	*speed_spin, *frequency_spin, *volume_spin, *gap_spin;
						/* Speed/tone/gap settings */
	XcwcpMultiLineEdit
			*display;		/* Sent char display */
	QToolButton	*startstop_button;	/* Toolbar start/stop button */
	QCheckBox	*reverse_paddles;	/* Reverse paddles option */
	QCheckBox	*curtis_mode_b;		/* Curtis mode B option */
	QCheckBox	*adaptive_receive;	/* Adaptive speed option */

	/* Receive poll timer. */
	QTimer		*poll_timer;		/* Receive poll timer. */	

	/* Circular buffer of cw characters awaiting send. */
	unsigned char	cq_queue[ 256 ];	/* Buffer */
	int		cq_head;		/* Buffer head index */
	int		cq_tail;		/* Buffer tail index */
	enum{CQ_IDLE,CQ_ACTIVE}
			cq_dequeue_state;	/* State of dequeuing chars */

	/* Monitor the state of CW library use - either active, or idle. */
	enum state {STATE_IDLE,STATE_ACTIVE}
			cwlib_use_state;	/* Active or idle */

	/* Saved receive speed, to reinstate adaptive tracked speed on start. */
	int		saved_receive_speed;

	/* Circular buffer manipulation functions. */
	void		queue_character (unsigned char);
						/* Queue a character */
	void		dequeue_character ();	/* Dequeue a character */
	void		unqueue_character ();	/* Delete a queued character */

	/* Polling for completed receive characters. */
	void		poll_receive ();	/* Look for receive character */
	
	/*
	 * Callback functions for cwlib.  For each, there is a static version
	 * for the whole class, and an instance version for each object.
	 * The class version calls the relevant instance version, based on
	 * which instance is the current registered cwlib user.
	 */
	static void	cwlib_callback_event_static ();
	void		cwlib_callback_event ();
	static void	cwlib_keying_event_static (int);
	void		cwlib_keying_event (int);
};

#endif
