TARGET = unity-mir
TEMPLATE = lib

QT       += core quick dbus
CONFIG   += link_pkgconfig

# CONFIG += c++11 # only enables C++0x
QMAKE_CXXFLAGS = -std=c++11
QMAKE_CXXFLAGS_RELEASE += -Werror     # so no stop on warning in debug builds
QMAKE_LFLAGS = -std=c++11 -Wl,-no-undefined

PKGCONFIG += mircommon mirserver ubuntu-platform-api

LIBS += -lubuntu_application_api_mirserver #FIXME platform-api pkgconfig should set this

SOURCES += \
    dbusscreen.cpp \
    initialsurfaceplacementstrategy.cpp \
    qmirserverapplication.cpp \
    qmirserver.cpp \
    sessionauthorizer.cpp \
    sessionlistener.cpp \
    shellserverconfiguration.cpp \
    surfacefactory.cpp \
    surfaceconfigurator.cpp \
    focussetter.cpp \
    serverstatuslistener.cpp

HEADERS += \
    dbusscreen.h \
    initialsurfaceplacementstrategy.h \
    qmirserverapplication.h \
    qmirserver.h \
    sessionauthorizer.h \
    sessionlistener.h \
    shellserverconfiguration.h \
    surfacefactory.h \
    surfaceconfigurator.h \
    logging.h \
    focussetter.h \
    serverstatuslistener.h

target.path = $$[QT_INSTALL_LIBS]

install_headers.files = qmirserverapplication.h \
    qmirserver.h \
    initialsurfaceplacementstrategy.h \
    sessionauthorizer.h \
    sessionlistener.h \
    shellserverconfiguration.h \
    surfacebuilder.h \
    surfacefactory.h
install_headers.path = /usr/include/unity-mir

### Generate pkg-config file
CONFIG += create_pc create_prl no_install_prl

QMAKE_PKGCONFIG_NAME = Unity-Mir
QMAKE_PKGCONFIG_DESCRIPTION = Qt wrapper for Mir functionality required by Unity
QMAKE_PKGCONFIG_PREFIX = $$INSTALLBASE
QMAKE_PKGCONFIG_LIBDIR = $$target.path
QMAKE_PKGCONFIG_INCDIR = $$installheaders.path
QMAKE_PKGCONFIG_VERSION = $$VERSION
QMAKE_PKGCONFIG_REQUIRES = ubuntu-platform-api mirclient mirserver Qt5Core
QMAKE_PKGCONFIG_DESTDIR = pkgconfig

INSTALLS += target install_headers
