TARGET = unityapplicationplugin
TEMPLATE = lib

QT       += core quick dbus
CONFIG   += link_pkgconfig plugin

# CONFIG += c++11 # only enables C++0x
QMAKE_CXXFLAGS = -std=c++11 -fvisibility=hidden -fvisibility-inlines-hidden
QMAKE_CXXFLAGS_RELEASE += -Werror     # so no stop on warning in debug builds
QMAKE_LFLAGS = -std=c++11 -Wl,-no-undefined

PKGCONFIG += mircommon mirserver ubuntu-platform-api glib-2.0 upstart-app-launch-2

INCLUDEPATH += ../../../unity-mir
LIBS += -L../../../unity-mir -lunity-mir \
    -lubuntu_application_api_mirserver #FIXME platform-api pkgconfig should set this

TARGET = $$qtLibraryTarget($$TARGET)
uri = Unity.Application

SOURCES += application_manager.cpp \
    application.cpp \
    desktopfilereader.cpp \
    plugin.cpp \
    applicationscreenshotprovider.cpp \
    dbuswindowstack.cpp \
    taskcontroller.cpp \
    mirsurface.cpp \
    mirsurfacemanager.cpp \
    inputarea.cpp \
    inputfilterarea.cpp \
    shellinputarea.cpp \
    ubuntukeyboardinfo.cpp

HEADERS += application_manager.h \
    application.h \
    desktopfilereader.h \
    applicationscreenshotprovider.h \
    dbuswindowstack.h \
    taskcontroller.h \
    mirsurface.h \
    mirsurfacemanager.h \
    shellinputarea.h \
    inputarea.h \
    inputfilterarea.h \
    ubuntukeyboardinfo.h \
    /usr/include/unity/shell/application/ApplicationManagerInterface.h \
    /usr/include/unity/shell/application/ApplicationInfoInterface.h

installPath = $$[QT_INSTALL_IMPORTS]/Unity-Mir/$$replace(uri, \\., /)

QML_FILES = qmldir ApplicationImage.qml OSKController.qml
qml_files.path = $$installPath
qml_files.files = $$QML_FILES

target.path = $$installPath

INSTALLS += target qml_files
