/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SURFACECONTROLLER_H
#define SURFACECONTROLLER_H

#include <QObject>

#include "mir/surfaces/surface_controller.h"

namespace mir { namespace surfaces { class SurfaceStackModel; }}

class SurfaceController : public QObject, public mir::surfaces::SurfaceController
{
    Q_OBJECT

public:
    explicit SurfaceController(const std::shared_ptr<mir::surfaces::SurfaceStackModel>& surfaceStack, QObject *parent = 0);
    ~SurfaceController();

    virtual std::weak_ptr<mir::surfaces::Surface> create_surface(
            mir::shell::Session* session,
            const mir::shell::SurfaceCreationParameters &params) override;
};

#endif // SURFACECONTROLLER_H
