/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import QtQuick.Window 2.0
import Unity.Application 0.1

Item {
    id: root
    property variant __oskSurface: null
    readonly property bool enabled: __oskSurface !== null

    Connections {
        target: SurfaceManager
        onSurfaceCreated: {
            // FIXME(greyback) Not using "type" as it set after surface created
            if (surface.name === "MaliitOnScreenKeyboard") {
                __oskSurface = surface;
            }
        }
        onSurfaceDestroyed: {
            if (surface.name === "MaliitOnScreenKeyboard") {
                __oskSurface = null;
            }
        }
    }

    /* Do not let touches that are meant for the OSK hit the Shell components behind it. */
    MouseArea {
        enabled: oskInputArea.enabled
        anchors.fill: oskInputArea
    }

    /* Need to position InputArea of oskSurface to cover the keyboard. But as shell
       currently has no idea the shape of the OSK (since OSK draws inside a fullscreen
       surface) we have to do guesswork so that the InputArea is correctly placed */
    InputArea {
        id: oskInputArea

        //FIXME(greyback) hardcoded - taken from maliit - Qt.inputMethod.keyboardRectangle not working
        readonly property real heightInPortrait: units.gu(30)
        readonly property real heightInLandscape: units.gu(20)

        readonly property int orientationAngle: Screen.angleBetween(Screen.primaryOrientation, Screen.orientation)

        surface: __oskSurface
        enabled: false

        state: orientationAngle.toString()

        states: [
            State {
                name: "0"
                PropertyChanges { target: oskInputArea; height: heightInPortrait; width: undefined }
                AnchorChanges { target: oskInputArea; anchors {
                        top: undefined
                        bottom: parent.bottom
                        left: parent.left
                        right: parent.right
                }}
            },
            State {
                name: "180"
                PropertyChanges { target: oskInputArea; height: heightInPortrait; width: undefined }
                AnchorChanges { target: oskInputArea; anchors {
                        top: parent.top
                        bottom: undefined
                        left: parent.left
                        right: parent.right
                }}
            },
            State {
                name: "270"
                PropertyChanges { target: oskInputArea; height: undefined; width: heightInLandscape }
                AnchorChanges { target: oskInputArea; anchors {
                        top: parent.top
                        bottom: parent.bottom
                        left: undefined
                        right: parent.right
                }}
            },
            State {
                name: "90"
                PropertyChanges { target: oskInputArea; height: undefined; width: heightInLandscape }
                AnchorChanges { target: oskInputArea; anchors {
                        top: parent.top
                        bottom: parent.bottom
                        left: parent.left
                        right: undefined
                }}
            }
        ]
    }

    Connections {
        target: __oskSurface

        onStateChanged: {
            if (__oskSurface.state === MirSurface.Maximized) {
                __oskSurface.visible = true;
                oskInputArea.enabled = true;
            } else {
                __oskSurface.visible = false;
                oskInputArea.enabled = false;
            }
        }
    }
}
