/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Ricardo Mendoza <ricardo.mendoza@canonical.com>
 */

#ifndef TASKCONTROLLER_H
#define TASKCONTROLLER_H

#include <QObject>

#include "application.h"

class ApplicationManager;
class TaskController : public QObject
{
    Q_OBJECT
public:
    explicit TaskController(ApplicationManager* parent);
    ~TaskController();

    void do_resume(Application* application);
    void do_suspend(Application* application);
    void do_respawn(Application* application);
};

#endif // TASKCONTROLLER_H
