/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Ricardo Mendoza <ricardo.mendoza@canonical.com>
 */

#include "logging.h"
#include "taskcontroller.h"
#include "application_manager.h"
#include <signal.h>
#include <unistd.h>

TaskController::TaskController(ApplicationManager *parent) :
    QObject(parent)
{
    DLOG("TaskController::TaskController (this=%p)", this);
}

TaskController::~TaskController()
{
    DLOG("TaskController::~TaskController (this=%p)", this);
}

void TaskController::do_suspend(Application* application)
{
    DLOG("TaskController::do_suspend (this=%p, application=%p)", this, application);
    if (application->state() == Application::Suspended)
        kill(application->pid(), SIGSTOP);
}

void TaskController::do_resume(Application* application)
{
    DLOG("TaskController::do_resume (this=%p, application=%p)", this, application);
    if (application->state() == Application::Suspended)
        kill(application->pid(), SIGCONT);
}

void TaskController::do_respawn(Application* application)
{
    DLOG("TaskController::do_respwn (this=%p, application=%p)", this, application);
    if (application->state() == Application::Stopped) {
        ApplicationManager *appMgr = static_cast<ApplicationManager*>(parent());
        appMgr->respawnApplication(application);
    }
}
