TARGET = unityapplicationplugin
TEMPLATE = lib

QT       += core quick dbus
CONFIG   += link_pkgconfig

# CONFIG += c++11 # only enables C++0x
QMAKE_CXXFLAGS = -std=c++11 -fvisibility=hidden -fvisibility-inlines-hidden
QMAKE_CXXFLAGS_RELEASE += -Werror     # so no stop on warning in debug builds
QMAKE_LFLAGS = -std=c++11 -Wl,-no-undefined

PKGCONFIG += mircommon mirserver ubuntu-platform-api

INCLUDEPATH += ../../../unity-mir
LIBS += -L../../../unity-mir -lunity-mir \
    -lubuntu_application_api_mirserver #FIXME platform-api pkgconfig should set this

TARGET = $$qtLibraryTarget($$TARGET)
uri = Unity.Application

SOURCES += application_manager.cpp \
    application.cpp \
    application_list_model.cpp \
    desktopfilereader.cpp \
    plugin.cpp \
    applicationscreenshotprovider.cpp \
    dbuswindowstack.cpp \
    taskcontroller.cpp \
    mirsurface.cpp \
    mirsurfacemanager.cpp \
    inputarea.cpp \
    inputfilterarea.cpp \
    shellinputarea.cpp

HEADERS += application_manager.h \
    application.h \
    application_list_model.h \
    desktopfilereader.h \
    applicationscreenshotprovider.h \
    dbuswindowstack.h \
    taskcontroller.h \
    mirsurface.h \
    mirsurfacemanager.h \
    shellinputarea.h \
    inputarea.h \
    inputfilterarea.h

installPath = $$[QT_INSTALL_IMPORTS]/$$replace(uri, \\., /)

QMLDIR_FILE = qmldir
qmldir_file.path = $$installPath
qmldir_file.files = $$QMLDIR_FILE

target.path = $$installPath

INSTALLS += target qmldir_file
