/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Qt
#include <QtQml/QtQml>

// local
#include "mirsurfacemanager.h"
#include "mirsurface.h"
#include "inputarea.h"
#include "inputfilterarea.h"
#include "shellinputarea.h"

// unity-mir
#include "logging.h"

static QObject* surfaceManagerSingleton(QQmlEngine* engine, QJSEngine* scriptEngine) {
    Q_UNUSED(engine);
    Q_UNUSED(scriptEngine);
    DLOG("surfaceManagerSingleton (engine=%p, scriptEngine=%p)", engine, scriptEngine);
    return MirSurfaceManager::singleton();
}

class UbuntuApplicationPlugin : public QQmlExtensionPlugin {
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.qt-project.Qt.QQmlExtensionInterface/1.0")

    virtual void registerTypes(const char* uri) {
        DLOG("UbuntuSurfacePlugin::registerTypes (this=%p, uri='%s')", this, uri);

        ASSERT(QLatin1String(uri) == QLatin1String("Unity.SurfaceManager"));
        qmlRegisterSingletonType<MirSurfaceManager>(
                    uri, 0, 1, "SurfaceManager", surfaceManagerSingleton);
        qmlRegisterUncreatableType<MirSurface>(
                    uri, 0, 1, "MirSurface", "MirSurface can't be instantiated");
        qmlRegisterType<InputArea>(uri, 0, 1, "InputArea");
        qmlRegisterType<ShellInputArea>(uri, 0, 1, "ShellInputArea");
        qmlRegisterType<InputFilterArea>(uri, 0, 1, "InputFilterArea");
    }
};

#include "plugin.moc"
