/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SURFACEBUILDER_H
#define SURFACEBUILDER_H

#include <QObject>

#include "mir/shell/surface_builder.h"

namespace mir { namespace surfaces { class SurfaceStackModel; }}

class SurfaceBuilder : public QObject, public mir::shell::SurfaceBuilder
{
    Q_OBJECT

public:
    explicit SurfaceBuilder(const std::shared_ptr<mir::surfaces::SurfaceStackModel>& surfaceStack, QObject *parent = 0);
    ~SurfaceBuilder();

    virtual std::weak_ptr<mir::surfaces::Surface> create_surface(
            mir::shell::Session* session,
            const mir::shell::SurfaceCreationParameters &params) override;

    virtual void destroy_surface(const std::weak_ptr<mir::surfaces::Surface>& surface) override;

private:
    const std::shared_ptr<mir::surfaces::SurfaceStackModel> m_surfaceStack;
};

#endif // SURFACEBUILDER_H
