TARGET = unitysurfacemanagerplugin
TEMPLATE = lib

QT       += core quick
CONFIG   += link_pkgconfig debug

# CONFIG += c++11 # only enables C++0x
QMAKE_CXXFLAGS = -std=c++11 -fvisibility=hidden -fvisibility-inlines-hidden
QMAKE_LFLAGS = -std=c++11 -Wl,-no-undefined

PKGCONFIG += mircommon mirserver ubuntu-platform-api

INCLUDEPATH += ../../../unity-mir
LIBS += -L../../../unity-mir -lunity-mir \
    -lubuntu_application_api_mirserver #FIXME platform-api pkgconfig should set this

TARGET = $$qtLibraryTarget($$TARGET)
uri = Unity.SurfaceManager

SOURCES += mirsurface.cpp \
    mirsurfacemanager.cpp \
    inputarea.cpp \
    shellinputarea.cpp \
    plugin.cpp

HEADERS += mirsurface.h \
    mirsurfacemanager.h \
    shellinputarea.h \
    inputarea.h

CONFIG(debug) {
    QMAKE_CXXFLAGS_DEBUG += -Werror
}

installPath = $$[QT_INSTALL_IMPORTS]/$$replace(uri, \\., /)

QMLDIR_FILE = qmldir
qmldir_file.path = $$installPath 
qmldir_file.files = $$QMLDIR_FILE

target.path = $$installPath

INSTALLS += target qmldir_file
