TARGET = unityapplicationmanagerplugin
TEMPLATE = lib

QT       += core quick dbus
CONFIG   += link_pkgconfig debug

# CONFIG += c++11 # only enables C++0x
QMAKE_CXXFLAGS = -std=c++11 -fvisibility=hidden -fvisibility-inlines-hidden
QMAKE_LFLAGS = -std=c++11 -Wl,-no-undefined

PKGCONFIG += mircommon mirserver

INCLUDEPATH += ../../../unity-mir
LIBS += -L../../../unity-mir -lunity-mir

TARGET = $$qtLibraryTarget($$TARGET)
uri = Unity.ApplicationManager

SOURCES += application_manager.cpp \
    application.cpp \
    application_list_model.cpp \
    desktopfilereader.cpp \
    plugin.cpp \
    applicationscreenshotprovider.cpp \
    dbuswindowstack.cpp

HEADERS += application_manager.h \
    application.h \
    application_list_model.h \
    desktopfilereader.h \
    applicationscreenshotprovider.h \
    dbuswindowstack.h

CONFIG(debug) {
    QMAKE_CXXFLAGS_DEBUG += -Werror
}

installPath = $$[QT_INSTALL_IMPORTS]/$$replace(uri, \\., /)

QMLDIR_FILE = qmldir
qmldir_file.path = $$installPath
qmldir_file.files = $$QMLDIR_FILE

target.path = $$installPath

INSTALLS += target qmldir_file
