/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License version 3, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <mir/surfaces/surface_stack_model.h>
#include <mir/shell/surface_creation_parameters.h> // TODO: Remove ~racarr

#include "surfacebuilder.h"

#include "logging.h"

namespace msh = mir::shell;
namespace ms = mir::surfaces;

SurfaceBuilder::SurfaceBuilder(const std::shared_ptr<ms::SurfaceStackModel>& surfaceStack, QObject *parent) :
    QObject(parent),
    m_surfaceStack(surfaceStack)
{
    DLOG("SurfaceBuilder::SurfaceBuilder (this=%p)", this);
}

SurfaceBuilder::~SurfaceBuilder()
{
    DLOG("SurfaceBuilder::~SurfaceBuilder (this=%p)", this);
}

std::weak_ptr<ms::Surface> SurfaceBuilder::create_surface(mir::shell::Session *session, const msh::SurfaceCreationParameters& params)
{
    DLOG("SurfaceBuilder::~create_surface (this=%p)", this);
    Q_UNUSED(session)

    static const ms::DepthId shellSurfaceDepth{1};
    static bool shellSurfaceFound = false;

    if (params.name == "Window 1" && !shellSurfaceFound) //TODO(greyback) Mir should identify shell surface somehow
    {
        DLOG("Shell depth");
        auto newParams = params;
        newParams.depth = shellSurfaceDepth;
        shellSurfaceFound = true;
        return m_surfaceStack->create_surface(newParams);
    }
    else
    {
        DLOG("Default depth");
        return m_surfaceStack->create_surface(params);
    }
}

void SurfaceBuilder::destroy_surface(const std::weak_ptr<ms::Surface>& surface)
{
    DLOG("SurfaceBuilder::~destroy_surface (this=%p)", this);

    m_surfaceStack->destroy_surface(surface);
}
