#!/bin/sh

set -e

# list all packages needed for a generic ubuntu touch initrd here
INCHROOTPKGS="initramfs-tools-ubuntu-touch android-tools-adbd dctrl-tools"

MIRROR=$(grep "^deb " /etc/apt/sources.list|head -1|cut -d' ' -f2)
RELEASE=$(lsb_release -cs)
ROOT=./build

# create a plain chroot to work in
rm -rf $ROOT
fakeroot -s chroot.save fakechroot debootstrap --variant=fakechroot $RELEASE $ROOT $MIRROR

# TODO this can be dropped once all packages are in main
sed -i 's/main$/main universe/' $ROOT/etc/apt/sources.list

# make sure we do not start daemons at install time
mv $ROOT/sbin/start-stop-daemon $ROOT/sbin/start-stop-daemon.REAL
cat > $ROOT/sbin/start-stop-daemon <<EOF
#!/bin/sh
echo 1>&2
echo 'Warning: Fake start-stop-daemon called, doing nothing.' 1>&2
exit 0
EOF
chmod a+rx $ROOT/sbin/start-stop-daemon

cat > $ROOT/usr/sbin/policy-rc.d <<EOF
#!/bin/sh
exit 101
EOF
chmod a+rx $ROOT/usr/sbin/policy-rc.d

mv $ROOT/sbin/initctl $ROOT/sbin/initctrl.REAL
cat > $ROOT/sbin/initctl <<EOF
#!/bin/sh
if [ "\$1" = version ]; then exec /sbin/initctl.REAL "\$@"; fi
echo 1>&2
echo 'Warning: Fake initctl called, doing nothing.' 1>&2
exit 0
EOF
chmod a+rx $ROOT/sbin/initctl

# install all packages we need to roll the generic initrd
fakeroot -i chroot.save fakechroot chroot $ROOT apt-get -y update
fakeroot -i chroot.save fakechroot chroot $ROOT apt-get -y install $INCHROOTPKGS

VER=$(fakeroot -i chroot.save fakechroot chroot ${ROOT} grep-status -P initramfs-tools-ubuntu-touch -s Version| sed  's/^.* //')
fakeroot -i chroot.save fakechroot chroot $ROOT update-initramfs -c -ktouch-$VER -v

# make a more generically named link so external scripts can use teh file without parsing the version
cd $ROOT/boot
ln -s initrd.img-touch-$VER initrd.img-touch
cd - >/dev/null 2>&1
