#!/bin/sh

set -e

MIRROR=$(grep "^deb " /etc/apt/sources.list|head -1|cut -d' ' -f2)
RELEASE=$(lsb_release -cs)
ROOT=./build
INCHROOTPKGS="initramfs-tools-ubuntu-touch android-tools-adbd dctrl-tools"

rm -rf $ROOT
fakeroot -s chroot.save fakechroot debootstrap --variant=fakechroot $RELEASE $ROOT $MIRROR

sed -i 's/main$/main universe/' $ROOT/etc/apt/sources.list
mv $ROOT/usr/sbin/invoke-rc.d $ROOT/usr/sbin/invoke-rc.d.orig
cp $ROOT/bin/true $ROOT/usr/sbin/invoke-rc.d

fakeroot -i chroot.save fakechroot chroot $ROOT apt-get -y update
fakeroot -i chroot.save fakechroot chroot $ROOT apt-get -y install $INCHROOTPKGS

VER=$(fakeroot -i chroot.save fakechroot chroot ${ROOT} grep-status -P initramfs-tools-ubuntu-touch -s Version| sed  's/^.* //')
fakeroot -i chroot.save fakechroot chroot $ROOT update-initramfs -c -ktouch-$VER -v
