#!/bin/sh

set -e

MIRROR=$(grep "^deb " /etc/apt/sources.list|head -1|cut -d' ' -f2)
RELEASE=$(lsb_release -cs)
ROOT=./build
INCHROOTPKGS="initramfs-tools-ubuntu-touch android-tools-adbd dctrl-tools"

rm -rf $ROOT
debootstrap $RELEASE $ROOT $MIRROR

sed -i 's/main$/main universe/' $ROOT/etc/apt/sources.list
mv $ROOT/usr/sbin/invoke-rc.d $ROOT/usr/sbin/invoke-rc.d.orig
cp $ROOT/bin/true $ROOT/usr/sbin/invoke-rc.d

chroot $ROOT apt-get -y update
chroot $ROOT apt-get -y install $INCHROOTPKGS

VER=$(chroot ${ROOT} grep-status -P initramfs-tools-ubuntu-touch -s Version| sed  's/^.* //')
chroot $ROOT update-initramfs -c -ktouch-$VER -v
