/*
 This file is part of Ubuntu-it Menu.

 Ubuntu-it Menu is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 Ubuntu-it Menu is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Ubuntu-it Menu.  If not, see http://www.gnu.org/licenses/.

 The copy of the GNU General Public License can be found here:
 chrome://ubuntuit/locale/GPLv2License.txt
*/

var ubuntuitOptions = {

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("extensions.ubuntuit.");
	},

	getMainWin: function() {
		return Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getMostRecentWindow("navigator:browser");
	},

	onDialogLoad: function() {
		var prefs = this.getPrefs();

		document.getElementById('BrowserMainMenu').checked = prefs.getBoolPref('BrowserMainMenu');
		document.getElementById('TitleMenu').checked = prefs.getBoolPref('TitleMenu');
		document.getElementById('ToolsMenu').checked = prefs.getBoolPref('ToolsMenu');
		document.getElementById('ContextMenu').checked = prefs.getBoolPref('ContextMenu');
		document.getElementById('ShowLogo').checked = prefs.getBoolPref('ShowLogo');
		document.getElementById('HomeLink').checked = prefs.getBoolPref('HomeLink');
		document.getElementById('SearchLink').checked = prefs.getBoolPref('SearchLink');
		document.getElementById('MainMenu').checked = prefs.getBoolPref('MainMenu');
		document.getElementById('WikiMenu').checked = prefs.getBoolPref('WikiMenu');
		document.getElementById('IrcMenu').checked = prefs.getBoolPref('IrcMenu');
		document.getElementById('MailMenu').checked = prefs.getBoolPref('MailMenu');
		document.getElementById('UtiliMenu').checked = prefs.getBoolPref('UtiliMenu');
		document.getElementById('ForumMenu').checked = prefs.getBoolPref('ForumMenu');
		document.getElementById('PersForumMenu').checked = prefs.getBoolPref('PersForumMenu');
		document.getElementById('ForumForumMenu').checked = prefs.getBoolPref('ForumForumMenu');
		document.getElementById('SectionsForumMenu').checked = prefs.getBoolPref('SectionsForumMenu');
		document.getElementById('Options').checked = prefs.getBoolPref('Options');
		document.getElementById('myWikiHomepage').value = prefs.getCharPref('myWikiHomepage');
		document.getElementById('myIntWikiHomepage').value = prefs.getCharPref('myIntWikiHomepage');
		document.getElementById('myLPHomepage').value = prefs.getCharPref('myLPHomepage');

		var derPrefsExpl = prefs.getCharPref('DerLinks').split(',');
		var derNames = new Array('Kub', 'Edub', 'Xub');
		var derIdNames = new Array('DerKub', 'DerEdub', 'DerXub');
		var derCheck;

		for (var y = 0; y < 3; y++)
		{
			derCheck = (derPrefsExpl[y] == derNames[y]);
			document.getElementById(derIdNames[y]).checked = derCheck;
		}

		var intPrefsExpl = prefs.getCharPref('IntLinks').split(',');
		var intNames = new Array('INT', 'FR', 'DE', 'ES');
		var intIdNames = new Array('IntInt', 'IntFr', 'IntDe', 'IntEs');
		var intCheck;

		for (var x = 0; x <= 3; x++)
		{
			intCheck = (intPrefsExpl[x] == intNames[x]);
			document.getElementById(intIdNames[x]).checked = intCheck;
		}
	},

	onDialogAccept: function() {
		var prefs = this.getPrefs();
		var win = this.getMainWin();

		prefs.setBoolPref('BrowserMainMenu',document.getElementById('BrowserMainMenu').checked);
		prefs.setBoolPref('TitleMenu',document.getElementById('TitleMenu').checked);
		prefs.setBoolPref('ToolsMenu',document.getElementById('ToolsMenu').checked);
		prefs.setBoolPref('ContextMenu',document.getElementById('ContextMenu').checked);
		prefs.setBoolPref('ShowLogo',document.getElementById('ShowLogo').checked);
		prefs.setBoolPref('HomeLink',document.getElementById('HomeLink').checked);
		prefs.setBoolPref('SearchLink',document.getElementById('SearchLink').checked);
		prefs.setBoolPref('MainMenu',document.getElementById('MainMenu').checked);
		prefs.setBoolPref('WikiMenu',document.getElementById('WikiMenu').checked);
		prefs.setBoolPref('IrcMenu',document.getElementById('IrcMenu').checked);
		prefs.setBoolPref('MailMenu',document.getElementById('MailMenu').checked);
		prefs.setBoolPref('UtiliMenu',document.getElementById('UtiliMenu').checked);
		prefs.setBoolPref('ForumMenu',document.getElementById('ForumMenu').checked);
		prefs.setBoolPref('PersForumMenu',document.getElementById('PersForumMenu').checked);
		prefs.setBoolPref('ForumForumMenu',document.getElementById('ForumForumMenu').checked);
		prefs.setBoolPref('SectionsForumMenu',document.getElementById('SectionsForumMenu').checked);
		prefs.setBoolPref('Options',document.getElementById('Options').checked);

		prefs.setCharPref('myWikiHomepage',document.getElementById('myWikiHomepage').value);
		prefs.setCharPref('myIntWikiHomepage',document.getElementById('myIntWikiHomepage').value);
		prefs.setCharPref('myLPHomepage',document.getElementById('myLPHomepage').value);

		var derNames = new Array('Kub', 'Edub', 'Xub');
		var derIdNames = new Array('DerKub', 'DerEdub', 'DerXub');
		var derPref = '';

		for (var y = 0; y < 3; y++)
		{
			var checkDerElement = document.getElementById(derIdNames[y]);
			if (checkDerElement.checked) {
				derPref = derPref + derNames[y];
			}
			derPref = derPref + ',';
		}
		prefs.setCharPref('DerLinks', derPref);

		var intNames = new Array('INT', 'FR', 'DE', 'ES');
		var intIdNames = new Array('IntInt', 'IntFr', 'IntDe', 'IntEs');
		var intPref = '';

		for (var x = 0; x <= 3; x++)
		{
			var checkIntElement = document.getElementById(intIdNames[x]);
			if (checkIntElement.checked) {
				intPref = intPref + intNames[x];
			}
			intPref = intPref + ',';
		}
		prefs.setCharPref('IntLinks', intPref);
	},
};
