/*
 This file is part of Ubuntu-it Menu.

 Ubuntu-it Menu is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 2 of the License, or
 (at your option) any later version.

 Ubuntu-it Menu is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Ubuntu-it Menu.  If not, see http://www.gnu.org/licenses/.

 The copy of the GNU General Public License can be found here:
 chrome://ubuntuit/locale/GPLv2License.txt
*/

window.addEventListener("load", ubuntuitLoad, false);

function ubuntuitLoad() {
	gBrowser.addProgressListener(ubuntuitProgress);
	ubuntuitCommon.onLoad();
}

window.addEventListener("unload", ubuntuitUnload, false);

function ubuntuitUnload() {
	gBrowser.removeProgressListener(ubuntuitProgress);
}

function ubuntuitCheckStatus() {
	var a = ubuntuitProgress.webprog;
	if ((a && !a.isLoadingDocument) || !a) {
		ubuntuitCommon.onLoad();
	}
}

var ubuntuitProgress = {

	webprog: null,

	QueryInterface: function(aIID) {
		if (aIID.equals(Components.interfaces.nsIWebProgressListener)   ||
		aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
		aIID.equals(Components.interfaces.nsISupports))
			return this;
		throw Components.results.NS_NOINTERFACE;
	},

	onLinkIconAvailable: function(a) { },
	onLocationChange: function(a,b,c) {
		this.webprog = a;
		window.setTimeout(ubuntuitCheckStatus,200);
	},

	onProgressChange: function(a,b,c,d,e,f) { },
	onSecurityChange: function(a,b,c) { },
	onStateChange: function(a,b,c,d) {
		if ((a && !a.isLoadingDocument) || !a) {
			ubuntuitCommon.onLoad();
		}
	},
	onStatusChange: function(a,b,c,d) { }
};

var ubuntuitCommon = {

	getPrefs: function() {
		return Components.classes["@mozilla.org/preferences-service;1"].
		getService(Components.interfaces.nsIPrefService).
		getBranch("extensions.ubuntuit.");
	},

	getMainWin: function() {
		return Components.classes["@mozilla.org/appshell/window-mediator;1"].
		getService(Components.interfaces.nsIWindowMediator).
		getMostRecentWindow("navigator:browser");
	},

	onLoad: function() {
		var prefs = this.getPrefs();
		var win = this.getMainWin();
		var class = 'menu-iconic';
		if (prefs.getBoolPref('ShowLogo'))
		{
			class += ' ubuntuit-net';
		}
		win.document.getElementById('ubuntuitTitleMenu').setAttribute('hidden', !prefs.getBoolPref('TitleMenu'));
		win.document.getElementById('ubuntuitTitleMenu').setAttribute('class', class);
		win.document.getElementById('ubuntuitToolsMenu').setAttribute('hidden', !prefs.getBoolPref('ToolsMenu'));
		win.document.getElementById('ubuntuitToolsMenu').setAttribute('class', class);
		win.document.getElementById('ubuntuitContextMenu').setAttribute('hidden', !prefs.getBoolPref('ContextMenu'));
		win.document.getElementById('ubuntuitContextMenu').setAttribute('class', class);
	},

	wikiHome: function(event) {
		var prefs = this.getPrefs();
		var myhome = prefs.getCharPref('myWikiHomepage');
		var url = "http://wiki.ubuntu-it.org/" + myhome;
		ubuntuitUrl.openClearLink(event, url);
	},

	wikiIntHome: function(event) {
		var prefs = this.getPrefs();
		var myhome = prefs.getCharPref('myIntWikiHomepage');
		var url = "https://wiki.ubuntu.com/" + myhome;
		ubuntuitUrl.openClearLink(event, url);
	},

	LPHomepage: function(event) {
		var prefs = this.getPrefs();
		var myhome = prefs.getCharPref('myLPHomepage');
		var url = "https://launchpad.net/~" + myhome;
		ubuntuitUrl.openClearLink(event, url);
	},

	mailArchive: function(event, type) {
		var data = new Date();
		var month = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
		var url = "https://lists.ubuntu.com/archives/ubuntu-it/" + data.getFullYear() + "-" + month[data.getMonth()] + "/" + type + ".html";
		ubuntuitUrl.openClearLink(event, url);			
	},

	onMenuLoad: function(numero) {
		var prefs = this.getPrefs();
		var win = this.getMainWin();
		var prefNames = new Array('HomeLink', 'MainMenu', 'WikiMenu', 'IrcMenu', 'MailMenu', 'UtiliMenu', 'ForumMenu', 'PersForumMenu', 'ForumForumMenu', 'SectionsForumMenu', 'Options');
		var multipleID = '';

		for (var y = 0; y <= 10; y++)
		{
			multipleID = 'ubuntuit' + prefNames[y] + numero;
            		win.document.getElementById(multipleID).setAttribute('hidden', !prefs.getBoolPref(prefNames[y]));
		}
            		win.document.getElementById('ubuntuitSepOptions' + numero).setAttribute('hidden', !prefs.getBoolPref('Options'));
	},

	onSubMenuLoad: function(menu) {
		var prefs = this.getPrefs();
		var win = this.getMainWin();

		var multipleDerID = '';
		var derpref = false;
		var derPrefSet = prefs.getCharPref('DerLinks');
		var submenu = menu.substr(0, menu.length - 1);
		derpref = (derPrefSet == ',,,,' || (derPrefSet.substr(0, 3) != 'Kub' && submenu == 'ForumMenu') || (derPrefSet == ',,,Gob,' && submenu != 'MainMenu'));
		multipleDerID = 'ubuntuitDer' + menu;
		win.document.getElementById(multipleDerID).setAttribute('hidden', derpref);
		

		var multipleIntID = '';
		var intpref = false;
		intpref = (prefs.getCharPref('IntLinks') == ',,,,');
		multipleIntID = 'ubuntuitInt' + menu;
		win.document.getElementById(multipleIntID).setAttribute('hidden', intpref);


		var noderint = (derpref && intpref);
		win.document.getElementById('ubuntuitSep' + menu).setAttribute('hidden', noderint);

		var numero = menu.substr(-1);
		if(menu.substr(0, menu.length - 1) == 'WikiMenu') {
			var myhome = prefs.getCharPref('myWikiHomepage');
			var wikiMyHome = 'ubuntuitWikiHomepage' + numero;
			if (myhome == '') {
		            	win.document.getElementById(wikiMyHome).setAttribute('hidden', true);
			} else {
		            	win.document.getElementById(wikiMyHome).setAttribute('hidden', false);
			}
		}
	},

	onUtiliMenuLoad: function(numero) {
		var prefs = this.getPrefs();
		var win = this.getMainWin();

		var myhome = prefs.getCharPref('myLPHomepage');
		var LPMyHome = 'ubuntuitLPHomepage' + numero;
		if (myhome == '') {
	            	win.document.getElementById(LPMyHome).setAttribute('hidden', true);
		} else {
	            	win.document.getElementById(LPMyHome).setAttribute('hidden', false);
		}
	},

	onDerMenuLoad: function(menu, kub, edub, xub, gob) {
		var prefs = this.getPrefs();
		var win = this.getMainWin();
		var derPrefsExpl = prefs.getCharPref('DerLinks').split(',');
		var derNames = new Array('Kub', 'Edub', 'Xub', 'Gob');
		var derId = new Array('ubuntuitDerK', 'ubuntuitDerE', 'ubuntuitDerX', 'ubuntuitDerG');
		var derSep = new Array(1, 3, 5);
		var multipleDerID = '';
		var derpreferenza = false;
		var derMaxNumber = new Array(kub, edub, xub, gob);

		for (var y = 0; y <= 3; y++)
		{
			derpreferenza = (derPrefsExpl[y] != derNames[y]);
			for (var t = 1; t <= derMaxNumber[y]; t++) {
				multipleDerID = derId[y] + t + menu + '';
				win.document.getElementById(multipleDerID).setAttribute('hidden', derpreferenza);
			}
		}

		var duesep = menu.substr(0, menu.length - 1);
		if(duesep == 'WikiMenu' || duesep == 'IrcMenu' || duesep == 'MailMenu') {
			// cicle stop before Gobuntu
			var derSepPoint = 0;
			for (var y = 0; y <= 2; y++)
			{
				if(derPrefsExpl[y] == derNames[y]) derSepPoint += derSep[y];
			}
			var dersep1 = (derSepPoint != 4 && derSepPoint != 6 && derSepPoint != 9);
			var dersep2 = (derSepPoint != 8 && derSepPoint != 9);
			win.document.getElementById('ubuntuitDerSep1' + menu).setAttribute('hidden', dersep1);
			win.document.getElementById('ubuntuitDerSep2' + menu).setAttribute('hidden', dersep2);
		}
	},

	onIntMenuLoad: function(menu, nint, nfr, nde, nes) {
		var prefs = this.getPrefs();
		var win = this.getMainWin();
		var intPrefs = prefs.getCharPref('IntLinks');
		var intPrefsExpl = intPrefs.split(',');
		var intNames = new Array('INT', 'FR', 'DE', 'ES');
		var intId = new Array('ubuntuitIntI', 'ubuntuitIntF', 'ubuntuitIntD', 'ubuntuitIntE');
		var intSep = new Array(1, 3, 5, 7);
		var multipleIntID = '';
		var intpreferenza = false;
		var intMaxNumber = new Array(nint, nfr, nde, nes);
		for (var y = 0; y <= 3; y++)
		{
			intpreferenza = (intPrefsExpl[y] != intNames[y]);
			for (var t = 1; t <= intMaxNumber[y]; t++) {
				multipleIntID = intId[y] + t + menu + '';
				win.document.getElementById(multipleIntID).setAttribute('hidden', intpreferenza);
			}
		}
		
		var genmenu = menu.substr(0, menu.length - 1);
		var numero = menu.substr(-1);
		if(genmenu == 'WikiMenu') {
			var myhome = prefs.getCharPref('myIntWikiHomepage');
			var wikiMyHome = 'ubuntuitIntWikiHomepage' + numero;
			if(intPrefsExpl[0] != intNames[0]) {
			            	win.document.getElementById(wikiMyHome).setAttribute('hidden', true);
			} else {	
				var viewhome = (myhome == '');
		            	win.document.getElementById(wikiMyHome).setAttribute('hidden', viewhome);
			}
		}

		if(genmenu == 'MailMenu' || genmenu == 'WikiMenu') {
			var intsep = (intPrefs.substr(0, 3) != 'INT' || intPrefs == 'INT,,,,');
			win.document.getElementById('ubuntuitIntSep' + genmenu + numero).setAttribute('hidden', intsep);
		}

		if(genmenu == 'MainMenu') {
			var intSepPoint = 0;
			for (var y = 0; y <= 3; y++)
			{
				if(intPrefsExpl[y] == intNames[y]) intSepPoint += intSep[y];
			}
			var intmainsep1 = (intSepPoint > 6 && intSepPoint != 9 && intSepPoint != 11 && intSepPoint != 16);
			var intmainsep2 = (intSepPoint < 8 || (intSepPoint > 11 && intSepPoint < 15));
			var intmainsep3 = (intSepPoint != 12 && intSepPoint < 15);
			win.document.getElementById('ubuntuitIntSep1' + genmenu + numero).setAttribute('hidden', intmainsep1);
			win.document.getElementById('ubuntuitIntSep2' + genmenu + numero).setAttribute('hidden', intmainsep2);
			win.document.getElementById('ubuntuitIntSep3' + genmenu + numero).setAttribute('hidden', intmainsep3);
		}
	},
};