#!/usr/bin/python

import unittest
from unittest.mock import (
    patch,
)

from ubuntucoreupgrader.apply import (
    ApplyUpgrade,
    ApplyUpgradeError,
)


class ApplyUpgradeTestCase(unittest.TestCase):

    def test_apply_update_success(self):
        with patch("ubuntucoreupgrader.apply.config"):
            a = ApplyUpgrade()
            a.UPGRADER = "true"
            res = a.apply_update()
            self.assertEqual(res, True)

    def test_apply_update_fail(self):
        with patch("ubuntucoreupgrader.apply.config"):
            a = ApplyUpgrade()
            a.UPGRADER = "false"
            with self.assertRaises(ApplyUpgradeError):
                res = a.apply_update()
                self.assertEqual(res, False)


if __name__ == "__main__":
    unittest.main()
