import json
import os
import subprocess
import time

from systemimage.config import config


class ApplyUpgradeError(Exception):
    pass


def is_sym_link_broken(path):
    '''
    Returns True if the specified path is a broken symbolic link, else
    False.
    '''
    try:
        os.lstat(path)
        os.stat(path)
    except:
        return True
    return False


def newest_mtime(directory):
    """
    Find the most recently modified file in a directory.
    Ignores broken symlinks.
    """
    files = [f for f in os.listdir(directory)
             if not is_sym_link_broken(os.path.join(directory, f))]

    return max([os.path.getmtime(os.path.join(directory, f)) for f in files])


class ApplyUpgrade:
    """Hook for system-image-cli"""

    UPGRADER = "ubuntu-core-upgrade"

    def apply_update(self):
        # FIXME: hardcoded, this should probably be merged with the
        #        two commands in bin/ anyway and all put here
        p = subprocess.Popen(
            [self.UPGRADER, "/writable/cache/ubuntu_command"])
        while p.poll() is None:
            # send alive ping
            if config.dbus_service:
                config.dbus_service.UpdateProgress(-1, -1)
            if getattr(config, "machine_readable", False):
                print("SPINNER:"+json.dumps({}))
            time.sleep(0.1)
        ret_code = p.poll()
        if ret_code != 0:
            raise ApplyUpgradeError(
                "%s exited with %s", self.UPGRADER, ret_code)
        return True

    # FIXME: this is the entry point that system-image-cli uses, we need
    #        to teach it that the name should be something more generic
    #        than reboot
    #
    # Note that this reboot logic is specific to in-place upgrades.
    def reboot(self):
        old_mtime_in_boot = newest_mtime("/boot")
        self.apply_update()
        if newest_mtime("/boot") > old_mtime_in_boot:
            print("Need reboot")
            subprocess.check_call(["/sbin/reboot"])
