import os
import subprocess


def newest_mtime(directory):
    return max([os.path.getmtime(os.path.join(directory, f))
                for f in os.listdir(directory)])


class ApplyUpgrade:
    """Hook for system-image-cli"""

    def apply_update(self):
        # FIXME: hardcoded, this should probably be merged with the
        #        two commands in bin/ anyway and all put here
        subprocess.check_call(
            ["ubuntu-core-upgrade", "/userdata/cache/ubuntu_command"])

    # FIXME: this is the entry point that system-image-cli uses, we need
    #        to teach it that the name should be something more generic
    #        than reboot
    def reboot(self):
        old_mtime_in_boot = newest_mtime("/boot")
        self.apply_update()
        if newest_mtime("/boot") > old_mtime_in_boot:
            print("Need reboot")
            subprocess.check_call(["/sbin/reboot"])
