/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "ua-ubuntu-advantage-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface com.canonical.UbuntuAdvantage.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UaUbuntuAdvantageManager
 * @title: UaUbuntuAdvantageManager
 * @short_description: Generated C code for the com.canonical.UbuntuAdvantage.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Manager.top_of_page">com.canonical.UbuntuAdvantage.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for com.canonical.UbuntuAdvantage.Manager ---- */

static const _ExtendedGDBusArgInfo _ua_ubuntu_advantage_manager_method_info_attach_IN_ARG_token =
{
  {
    -1,
    (gchar *) "token",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ua_ubuntu_advantage_manager_method_info_attach_IN_ARG_pointers[] =
{
  &_ua_ubuntu_advantage_manager_method_info_attach_IN_ARG_token.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ua_ubuntu_advantage_manager_method_info_attach =
{
  {
    -1,
    (gchar *) "Attach",
    (GDBusArgInfo **) &_ua_ubuntu_advantage_manager_method_info_attach_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-attach",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ua_ubuntu_advantage_manager_method_info_detach =
{
  {
    -1,
    (gchar *) "Detach",
    NULL,
    NULL,
    NULL
  },
  "handle-detach",
  FALSE
};

static const GDBusMethodInfo * const _ua_ubuntu_advantage_manager_method_info_pointers[] =
{
  &_ua_ubuntu_advantage_manager_method_info_attach.parent_struct,
  &_ua_ubuntu_advantage_manager_method_info_detach.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ua_ubuntu_advantage_manager_property_info_attached =
{
  {
    -1,
    (gchar *) "Attached",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "attached",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ua_ubuntu_advantage_manager_property_info_daemon_version =
{
  {
    -1,
    (gchar *) "DaemonVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "daemon-version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ua_ubuntu_advantage_manager_property_info_pointers[] =
{
  &_ua_ubuntu_advantage_manager_property_info_attached.parent_struct,
  &_ua_ubuntu_advantage_manager_property_info_daemon_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ua_ubuntu_advantage_manager_interface_info =
{
  {
    -1,
    (gchar *) "com.canonical.UbuntuAdvantage.Manager",
    (GDBusMethodInfo **) &_ua_ubuntu_advantage_manager_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_ua_ubuntu_advantage_manager_property_info_pointers,
    NULL
  },
  "ubuntu-advantage-manager",
};


/**
 * ua_ubuntu_advantage_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Manager.top_of_page">com.canonical.UbuntuAdvantage.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ua_ubuntu_advantage_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ua_ubuntu_advantage_manager_interface_info.parent_struct;
}

/**
 * ua_ubuntu_advantage_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UaUbuntuAdvantageManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ua_ubuntu_advantage_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "attached");
  g_object_class_override_property (klass, property_id_begin++, "daemon-version");
  return property_id_begin - 1;
}



/**
 * UaUbuntuAdvantageManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Manager.top_of_page">com.canonical.UbuntuAdvantage.Manager</link>.
 */

/**
 * UaUbuntuAdvantageManagerIface:
 * @parent_iface: The parent interface.
 * @handle_attach: Handler for the #UaUbuntuAdvantageManager::handle-attach signal.
 * @handle_detach: Handler for the #UaUbuntuAdvantageManager::handle-detach signal.
 * @get_attached: Getter for the #UaUbuntuAdvantageManager:attached property.
 * @get_daemon_version: Getter for the #UaUbuntuAdvantageManager:daemon-version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Manager.top_of_page">com.canonical.UbuntuAdvantage.Manager</link>.
 */

typedef UaUbuntuAdvantageManagerIface UaUbuntuAdvantageManagerInterface;
G_DEFINE_INTERFACE (UaUbuntuAdvantageManager, ua_ubuntu_advantage_manager, G_TYPE_OBJECT)

static void
ua_ubuntu_advantage_manager_default_init (UaUbuntuAdvantageManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UaUbuntuAdvantageManager::handle-attach:
   * @object: A #UaUbuntuAdvantageManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_token: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Attach">Attach()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ua_ubuntu_advantage_manager_complete_attach() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-attach",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UaUbuntuAdvantageManagerIface, handle_attach),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * UaUbuntuAdvantageManager::handle-detach:
   * @object: A #UaUbuntuAdvantageManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Detach">Detach()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ua_ubuntu_advantage_manager_complete_detach() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-detach",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UaUbuntuAdvantageManagerIface, handle_detach),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * UaUbuntuAdvantageManager:attached:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Manager.Attached">"Attached"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("attached", "Attached", "Attached", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UaUbuntuAdvantageManager:daemon-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Manager.DaemonVersion">"DaemonVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("daemon-version", "DaemonVersion", "DaemonVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ua_ubuntu_advantage_manager_get_attached: (skip)
 * @object: A #UaUbuntuAdvantageManager.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Manager.Attached">"Attached"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
ua_ubuntu_advantage_manager_get_attached (UaUbuntuAdvantageManager *object)
{
  return UA_UBUNTU_ADVANTAGE_MANAGER_GET_IFACE (object)->get_attached (object);
}

/**
 * ua_ubuntu_advantage_manager_set_attached: (skip)
 * @object: A #UaUbuntuAdvantageManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Manager.Attached">"Attached"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ua_ubuntu_advantage_manager_set_attached (UaUbuntuAdvantageManager *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "attached", value, NULL);
}

/**
 * ua_ubuntu_advantage_manager_get_daemon_version: (skip)
 * @object: A #UaUbuntuAdvantageManager.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Manager.DaemonVersion">"DaemonVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ua_ubuntu_advantage_manager_dup_daemon_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ua_ubuntu_advantage_manager_get_daemon_version (UaUbuntuAdvantageManager *object)
{
  return UA_UBUNTU_ADVANTAGE_MANAGER_GET_IFACE (object)->get_daemon_version (object);
}

/**
 * ua_ubuntu_advantage_manager_dup_daemon_version: (skip)
 * @object: A #UaUbuntuAdvantageManager.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Manager.DaemonVersion">"DaemonVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ua_ubuntu_advantage_manager_dup_daemon_version (UaUbuntuAdvantageManager *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "daemon-version", &value, NULL);
  return value;
}

/**
 * ua_ubuntu_advantage_manager_set_daemon_version: (skip)
 * @object: A #UaUbuntuAdvantageManager.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Manager.DaemonVersion">"DaemonVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ua_ubuntu_advantage_manager_set_daemon_version (UaUbuntuAdvantageManager *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "daemon-version", value, NULL);
}

/**
 * ua_ubuntu_advantage_manager_call_attach:
 * @proxy: A #UaUbuntuAdvantageManagerProxy.
 * @arg_token: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Attach">Attach()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_manager_call_attach_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_manager_call_attach_sync() for the synchronous, blocking version of this method.
 */
void
ua_ubuntu_advantage_manager_call_attach (
    UaUbuntuAdvantageManager *proxy,
    const gchar *arg_token,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Attach",
    g_variant_new ("(s)",
                   arg_token),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ua_ubuntu_advantage_manager_call_attach_finish:
 * @proxy: A #UaUbuntuAdvantageManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_manager_call_attach().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ua_ubuntu_advantage_manager_call_attach().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_manager_call_attach_finish (
    UaUbuntuAdvantageManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_manager_call_attach_sync:
 * @proxy: A #UaUbuntuAdvantageManagerProxy.
 * @arg_token: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Attach">Attach()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_manager_call_attach() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_manager_call_attach_sync (
    UaUbuntuAdvantageManager *proxy,
    const gchar *arg_token,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Attach",
    g_variant_new ("(s)",
                   arg_token),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_manager_call_detach:
 * @proxy: A #UaUbuntuAdvantageManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Detach">Detach()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_manager_call_detach_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_manager_call_detach_sync() for the synchronous, blocking version of this method.
 */
void
ua_ubuntu_advantage_manager_call_detach (
    UaUbuntuAdvantageManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Detach",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ua_ubuntu_advantage_manager_call_detach_finish:
 * @proxy: A #UaUbuntuAdvantageManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_manager_call_detach().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ua_ubuntu_advantage_manager_call_detach().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_manager_call_detach_finish (
    UaUbuntuAdvantageManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_manager_call_detach_sync:
 * @proxy: A #UaUbuntuAdvantageManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Detach">Detach()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_manager_call_detach() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_manager_call_detach_sync (
    UaUbuntuAdvantageManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Detach",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_manager_complete_attach:
 * @object: A #UaUbuntuAdvantageManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Attach">Attach()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ua_ubuntu_advantage_manager_complete_attach (
    UaUbuntuAdvantageManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ua_ubuntu_advantage_manager_complete_detach:
 * @object: A #UaUbuntuAdvantageManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Manager.Detach">Detach()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ua_ubuntu_advantage_manager_complete_detach (
    UaUbuntuAdvantageManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UaUbuntuAdvantageManagerProxy:
 *
 * The #UaUbuntuAdvantageManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UaUbuntuAdvantageManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UaUbuntuAdvantageManagerProxy.
 */

struct _UaUbuntuAdvantageManagerProxyPrivate
{
  GData *qdata;
};

static void ua_ubuntu_advantage_manager_proxy_iface_init (UaUbuntuAdvantageManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageManagerProxy, ua_ubuntu_advantage_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UaUbuntuAdvantageManagerProxy)
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER, ua_ubuntu_advantage_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageManagerProxy, ua_ubuntu_advantage_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER, ua_ubuntu_advantage_manager_proxy_iface_init))

#endif
static void
ua_ubuntu_advantage_manager_proxy_finalize (GObject *object)
{
  UaUbuntuAdvantageManagerProxy *proxy = UA_UBUNTU_ADVANTAGE_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ua_ubuntu_advantage_manager_proxy_parent_class)->finalize (object);
}

static void
ua_ubuntu_advantage_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ua_ubuntu_advantage_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ua_ubuntu_advantage_manager_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface com.canonical.UbuntuAdvantage.Manager: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ua_ubuntu_advantage_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ua_ubuntu_advantage_manager_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "com.canonical.UbuntuAdvantage.Manager", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ua_ubuntu_advantage_manager_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ua_ubuntu_advantage_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UA_TYPE_UBUNTU_ADVANTAGE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UA_TYPE_UBUNTU_ADVANTAGE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ua_ubuntu_advantage_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UaUbuntuAdvantageManagerProxy *proxy = UA_UBUNTU_ADVANTAGE_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
ua_ubuntu_advantage_manager_proxy_get_attached (UaUbuntuAdvantageManager *object)
{
  UaUbuntuAdvantageManagerProxy *proxy = UA_UBUNTU_ADVANTAGE_MANAGER_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Attached");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ua_ubuntu_advantage_manager_proxy_get_daemon_version (UaUbuntuAdvantageManager *object)
{
  UaUbuntuAdvantageManagerProxy *proxy = UA_UBUNTU_ADVANTAGE_MANAGER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DaemonVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
ua_ubuntu_advantage_manager_proxy_init (UaUbuntuAdvantageManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ua_ubuntu_advantage_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UA_TYPE_UBUNTU_ADVANTAGE_MANAGER_PROXY, UaUbuntuAdvantageManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ua_ubuntu_advantage_manager_interface_info ());
}

static void
ua_ubuntu_advantage_manager_proxy_class_init (UaUbuntuAdvantageManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ua_ubuntu_advantage_manager_proxy_finalize;
  gobject_class->get_property = ua_ubuntu_advantage_manager_proxy_get_property;
  gobject_class->set_property = ua_ubuntu_advantage_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ua_ubuntu_advantage_manager_proxy_g_signal;
  proxy_class->g_properties_changed = ua_ubuntu_advantage_manager_proxy_g_properties_changed;

  ua_ubuntu_advantage_manager_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UaUbuntuAdvantageManagerProxyPrivate));
#endif
}

static void
ua_ubuntu_advantage_manager_proxy_iface_init (UaUbuntuAdvantageManagerIface *iface)
{
  iface->get_attached = ua_ubuntu_advantage_manager_proxy_get_attached;
  iface->get_daemon_version = ua_ubuntu_advantage_manager_proxy_get_daemon_version;
}

/**
 * ua_ubuntu_advantage_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Manager.top_of_page">com.canonical.UbuntuAdvantage.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_manager_proxy_new_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ua_ubuntu_advantage_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Manager", NULL);
}

/**
 * ua_ubuntu_advantage_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ua_ubuntu_advantage_manager_proxy_new().
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageManager *
ua_ubuntu_advantage_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_MANAGER (ret);
  else
    return NULL;
}

/**
 * ua_ubuntu_advantage_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Manager.top_of_page">com.canonical.UbuntuAdvantage.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageManager *
ua_ubuntu_advantage_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Manager", NULL);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_MANAGER (ret);
  else
    return NULL;
}


/**
 * ua_ubuntu_advantage_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ua_ubuntu_advantage_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ua_ubuntu_advantage_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Manager", NULL);
}

/**
 * ua_ubuntu_advantage_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ua_ubuntu_advantage_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageManager *
ua_ubuntu_advantage_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_MANAGER (ret);
  else
    return NULL;
}

/**
 * ua_ubuntu_advantage_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ua_ubuntu_advantage_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageManager *
ua_ubuntu_advantage_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Manager", NULL);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UaUbuntuAdvantageManagerSkeleton:
 *
 * The #UaUbuntuAdvantageManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UaUbuntuAdvantageManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UaUbuntuAdvantageManagerSkeleton.
 */

struct _UaUbuntuAdvantageManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ua_ubuntu_advantage_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UA_TYPE_UBUNTU_ADVANTAGE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UA_TYPE_UBUNTU_ADVANTAGE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ua_ubuntu_advantage_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ua_ubuntu_advantage_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ua_ubuntu_advantage_manager_skeleton_vtable =
{
  _ua_ubuntu_advantage_manager_skeleton_handle_method_call,
  _ua_ubuntu_advantage_manager_skeleton_handle_get_property,
  _ua_ubuntu_advantage_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ua_ubuntu_advantage_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ua_ubuntu_advantage_manager_interface_info ();
}

static GDBusInterfaceVTable *
ua_ubuntu_advantage_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ua_ubuntu_advantage_manager_skeleton_vtable;
}

static GVariant *
ua_ubuntu_advantage_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ua_ubuntu_advantage_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ua_ubuntu_advantage_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ua_ubuntu_advantage_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ua_ubuntu_advantage_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.canonical.UbuntuAdvantage.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ua_ubuntu_advantage_manager_emit_changed (gpointer user_data);

static void
ua_ubuntu_advantage_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ua_ubuntu_advantage_manager_emit_changed (skeleton);
}

static void ua_ubuntu_advantage_manager_skeleton_iface_init (UaUbuntuAdvantageManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageManagerSkeleton, ua_ubuntu_advantage_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UaUbuntuAdvantageManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER, ua_ubuntu_advantage_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageManagerSkeleton, ua_ubuntu_advantage_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER, ua_ubuntu_advantage_manager_skeleton_iface_init))

#endif
static void
ua_ubuntu_advantage_manager_skeleton_finalize (GObject *object)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ua_ubuntu_advantage_manager_skeleton_parent_class)->finalize (object);
}

static void
ua_ubuntu_advantage_manager_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ua_ubuntu_advantage_manager_emit_changed (gpointer user_data)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "com.canonical.UbuntuAdvantage.Manager",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ua_ubuntu_advantage_manager_schedule_emit_changed (UaUbuntuAdvantageManagerSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ua_ubuntu_advantage_manager_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ua_ubuntu_advantage_manager_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ua_ubuntu_advantage_manager_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ua_ubuntu_advantage_manager_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _ua_ubuntu_advantage_manager_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ua_ubuntu_advantage_manager_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ua_ubuntu_advantage_manager_skeleton_init (UaUbuntuAdvantageManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ua_ubuntu_advantage_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UA_TYPE_UBUNTU_ADVANTAGE_MANAGER_SKELETON, UaUbuntuAdvantageManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
}

static gboolean 
ua_ubuntu_advantage_manager_skeleton_get_attached (UaUbuntuAdvantageManager *object)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ua_ubuntu_advantage_manager_skeleton_get_daemon_version (UaUbuntuAdvantageManager *object)
{
  UaUbuntuAdvantageManagerSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_MANAGER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ua_ubuntu_advantage_manager_skeleton_class_init (UaUbuntuAdvantageManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ua_ubuntu_advantage_manager_skeleton_finalize;
  gobject_class->get_property = ua_ubuntu_advantage_manager_skeleton_get_property;
  gobject_class->set_property = ua_ubuntu_advantage_manager_skeleton_set_property;
  gobject_class->notify       = ua_ubuntu_advantage_manager_skeleton_notify;


  ua_ubuntu_advantage_manager_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ua_ubuntu_advantage_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ua_ubuntu_advantage_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ua_ubuntu_advantage_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ua_ubuntu_advantage_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UaUbuntuAdvantageManagerSkeletonPrivate));
#endif
}

static void
ua_ubuntu_advantage_manager_skeleton_iface_init (UaUbuntuAdvantageManagerIface *iface)
{
  iface->get_attached = ua_ubuntu_advantage_manager_skeleton_get_attached;
  iface->get_daemon_version = ua_ubuntu_advantage_manager_skeleton_get_daemon_version;
}

/**
 * ua_ubuntu_advantage_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Manager.top_of_page">com.canonical.UbuntuAdvantage.Manager</link>.
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageManagerSkeleton): The skeleton object.
 */
UaUbuntuAdvantageManager *
ua_ubuntu_advantage_manager_skeleton_new (void)
{
  return UA_UBUNTU_ADVANTAGE_MANAGER (g_object_new (UA_TYPE_UBUNTU_ADVANTAGE_MANAGER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface com.canonical.UbuntuAdvantage.Service
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:UaUbuntuAdvantageService
 * @title: UaUbuntuAdvantageService
 * @short_description: Generated C code for the com.canonical.UbuntuAdvantage.Service D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Service.top_of_page">com.canonical.UbuntuAdvantage.Service</link> D-Bus interface in C.
 */

/* ---- Introspection data for com.canonical.UbuntuAdvantage.Service ---- */

static const _ExtendedGDBusMethodInfo _ua_ubuntu_advantage_service_method_info_enable =
{
  {
    -1,
    (gchar *) "Enable",
    NULL,
    NULL,
    NULL
  },
  "handle-enable",
  FALSE
};

static const _ExtendedGDBusMethodInfo _ua_ubuntu_advantage_service_method_info_disable =
{
  {
    -1,
    (gchar *) "Disable",
    NULL,
    NULL,
    NULL
  },
  "handle-disable",
  FALSE
};

static const GDBusMethodInfo * const _ua_ubuntu_advantage_service_method_info_pointers[] =
{
  &_ua_ubuntu_advantage_service_method_info_enable.parent_struct,
  &_ua_ubuntu_advantage_service_method_info_disable.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _ua_ubuntu_advantage_service_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ua_ubuntu_advantage_service_property_info_description =
{
  {
    -1,
    (gchar *) "Description",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "description",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ua_ubuntu_advantage_service_property_info_entitled =
{
  {
    -1,
    (gchar *) "Entitled",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "entitled",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _ua_ubuntu_advantage_service_property_info_status =
{
  {
    -1,
    (gchar *) "Status",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "status",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _ua_ubuntu_advantage_service_property_info_pointers[] =
{
  &_ua_ubuntu_advantage_service_property_info_name.parent_struct,
  &_ua_ubuntu_advantage_service_property_info_description.parent_struct,
  &_ua_ubuntu_advantage_service_property_info_entitled.parent_struct,
  &_ua_ubuntu_advantage_service_property_info_status.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ua_ubuntu_advantage_service_interface_info =
{
  {
    -1,
    (gchar *) "com.canonical.UbuntuAdvantage.Service",
    (GDBusMethodInfo **) &_ua_ubuntu_advantage_service_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_ua_ubuntu_advantage_service_property_info_pointers,
    NULL
  },
  "ubuntu-advantage-service",
};


/**
 * ua_ubuntu_advantage_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Service.top_of_page">com.canonical.UbuntuAdvantage.Service</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ua_ubuntu_advantage_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ua_ubuntu_advantage_service_interface_info.parent_struct;
}

/**
 * ua_ubuntu_advantage_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #UaUbuntuAdvantageService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ua_ubuntu_advantage_service_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "description");
  g_object_class_override_property (klass, property_id_begin++, "entitled");
  g_object_class_override_property (klass, property_id_begin++, "status");
  return property_id_begin - 1;
}



/**
 * UaUbuntuAdvantageService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Service.top_of_page">com.canonical.UbuntuAdvantage.Service</link>.
 */

/**
 * UaUbuntuAdvantageServiceIface:
 * @parent_iface: The parent interface.
 * @handle_disable: Handler for the #UaUbuntuAdvantageService::handle-disable signal.
 * @handle_enable: Handler for the #UaUbuntuAdvantageService::handle-enable signal.
 * @get_description: Getter for the #UaUbuntuAdvantageService:description property.
 * @get_entitled: Getter for the #UaUbuntuAdvantageService:entitled property.
 * @get_name: Getter for the #UaUbuntuAdvantageService:name property.
 * @get_status: Getter for the #UaUbuntuAdvantageService:status property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Service.top_of_page">com.canonical.UbuntuAdvantage.Service</link>.
 */

typedef UaUbuntuAdvantageServiceIface UaUbuntuAdvantageServiceInterface;
G_DEFINE_INTERFACE (UaUbuntuAdvantageService, ua_ubuntu_advantage_service, G_TYPE_OBJECT)

static void
ua_ubuntu_advantage_service_default_init (UaUbuntuAdvantageServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * UaUbuntuAdvantageService::handle-enable:
   * @object: A #UaUbuntuAdvantageService.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Enable">Enable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ua_ubuntu_advantage_service_complete_enable() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UaUbuntuAdvantageServiceIface, handle_enable),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * UaUbuntuAdvantageService::handle-disable:
   * @object: A #UaUbuntuAdvantageService.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Disable">Disable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ua_ubuntu_advantage_service_complete_disable() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-disable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (UaUbuntuAdvantageServiceIface, handle_disable),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject properties for D-Bus properties: */
  /**
   * UaUbuntuAdvantageService:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UaUbuntuAdvantageService:description:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Description">"Description"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("description", "Description", "Description", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UaUbuntuAdvantageService:entitled:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Entitled">"Entitled"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("entitled", "Entitled", "Entitled", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * UaUbuntuAdvantageService:status:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Status">"Status"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("status", "Status", "Status", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * ua_ubuntu_advantage_service_get_name: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ua_ubuntu_advantage_service_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ua_ubuntu_advantage_service_get_name (UaUbuntuAdvantageService *object)
{
  return UA_UBUNTU_ADVANTAGE_SERVICE_GET_IFACE (object)->get_name (object);
}

/**
 * ua_ubuntu_advantage_service_dup_name: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ua_ubuntu_advantage_service_dup_name (UaUbuntuAdvantageService *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * ua_ubuntu_advantage_service_set_name: (skip)
 * @object: A #UaUbuntuAdvantageService.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ua_ubuntu_advantage_service_set_name (UaUbuntuAdvantageService *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * ua_ubuntu_advantage_service_get_description: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Description">"Description"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ua_ubuntu_advantage_service_dup_description() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ua_ubuntu_advantage_service_get_description (UaUbuntuAdvantageService *object)
{
  return UA_UBUNTU_ADVANTAGE_SERVICE_GET_IFACE (object)->get_description (object);
}

/**
 * ua_ubuntu_advantage_service_dup_description: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Description">"Description"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ua_ubuntu_advantage_service_dup_description (UaUbuntuAdvantageService *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "description", &value, NULL);
  return value;
}

/**
 * ua_ubuntu_advantage_service_set_description: (skip)
 * @object: A #UaUbuntuAdvantageService.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Description">"Description"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ua_ubuntu_advantage_service_set_description (UaUbuntuAdvantageService *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "description", value, NULL);
}

/**
 * ua_ubuntu_advantage_service_get_entitled: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Entitled">"Entitled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ua_ubuntu_advantage_service_dup_entitled() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ua_ubuntu_advantage_service_get_entitled (UaUbuntuAdvantageService *object)
{
  return UA_UBUNTU_ADVANTAGE_SERVICE_GET_IFACE (object)->get_entitled (object);
}

/**
 * ua_ubuntu_advantage_service_dup_entitled: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Entitled">"Entitled"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ua_ubuntu_advantage_service_dup_entitled (UaUbuntuAdvantageService *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "entitled", &value, NULL);
  return value;
}

/**
 * ua_ubuntu_advantage_service_set_entitled: (skip)
 * @object: A #UaUbuntuAdvantageService.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Entitled">"Entitled"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ua_ubuntu_advantage_service_set_entitled (UaUbuntuAdvantageService *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "entitled", value, NULL);
}

/**
 * ua_ubuntu_advantage_service_get_status: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets the value of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use ua_ubuntu_advantage_service_dup_status() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
ua_ubuntu_advantage_service_get_status (UaUbuntuAdvantageService *object)
{
  return UA_UBUNTU_ADVANTAGE_SERVICE_GET_IFACE (object)->get_status (object);
}

/**
 * ua_ubuntu_advantage_service_dup_status: (skip)
 * @object: A #UaUbuntuAdvantageService.
 *
 * Gets a copy of the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Status">"Status"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
ua_ubuntu_advantage_service_dup_status (UaUbuntuAdvantageService *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "status", &value, NULL);
  return value;
}

/**
 * ua_ubuntu_advantage_service_set_status: (skip)
 * @object: A #UaUbuntuAdvantageService.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-com-canonical-UbuntuAdvantage-Service.Status">"Status"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
ua_ubuntu_advantage_service_set_status (UaUbuntuAdvantageService *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "status", value, NULL);
}

/**
 * ua_ubuntu_advantage_service_call_enable:
 * @proxy: A #UaUbuntuAdvantageServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Enable">Enable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_service_call_enable_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_service_call_enable_sync() for the synchronous, blocking version of this method.
 */
void
ua_ubuntu_advantage_service_call_enable (
    UaUbuntuAdvantageService *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ua_ubuntu_advantage_service_call_enable_finish:
 * @proxy: A #UaUbuntuAdvantageServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_service_call_enable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ua_ubuntu_advantage_service_call_enable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_service_call_enable_finish (
    UaUbuntuAdvantageService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_service_call_enable_sync:
 * @proxy: A #UaUbuntuAdvantageServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Enable">Enable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_service_call_enable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_service_call_enable_sync (
    UaUbuntuAdvantageService *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Enable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_service_call_disable:
 * @proxy: A #UaUbuntuAdvantageServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Disable">Disable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_service_call_disable_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_service_call_disable_sync() for the synchronous, blocking version of this method.
 */
void
ua_ubuntu_advantage_service_call_disable (
    UaUbuntuAdvantageService *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ua_ubuntu_advantage_service_call_disable_finish:
 * @proxy: A #UaUbuntuAdvantageServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_service_call_disable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ua_ubuntu_advantage_service_call_disable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_service_call_disable_finish (
    UaUbuntuAdvantageService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_service_call_disable_sync:
 * @proxy: A #UaUbuntuAdvantageServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Disable">Disable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_service_call_disable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ua_ubuntu_advantage_service_call_disable_sync (
    UaUbuntuAdvantageService *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Disable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ua_ubuntu_advantage_service_complete_enable:
 * @object: A #UaUbuntuAdvantageService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Enable">Enable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ua_ubuntu_advantage_service_complete_enable (
    UaUbuntuAdvantageService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * ua_ubuntu_advantage_service_complete_disable:
 * @object: A #UaUbuntuAdvantageService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-com-canonical-UbuntuAdvantage-Service.Disable">Disable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ua_ubuntu_advantage_service_complete_disable (
    UaUbuntuAdvantageService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * UaUbuntuAdvantageServiceProxy:
 *
 * The #UaUbuntuAdvantageServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UaUbuntuAdvantageServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UaUbuntuAdvantageServiceProxy.
 */

struct _UaUbuntuAdvantageServiceProxyPrivate
{
  GData *qdata;
};

static void ua_ubuntu_advantage_service_proxy_iface_init (UaUbuntuAdvantageServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageServiceProxy, ua_ubuntu_advantage_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (UaUbuntuAdvantageServiceProxy)
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE, ua_ubuntu_advantage_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageServiceProxy, ua_ubuntu_advantage_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE, ua_ubuntu_advantage_service_proxy_iface_init))

#endif
static void
ua_ubuntu_advantage_service_proxy_finalize (GObject *object)
{
  UaUbuntuAdvantageServiceProxy *proxy = UA_UBUNTU_ADVANTAGE_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ua_ubuntu_advantage_service_proxy_parent_class)->finalize (object);
}

static void
ua_ubuntu_advantage_service_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _ua_ubuntu_advantage_service_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
ua_ubuntu_advantage_service_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface com.canonical.UbuntuAdvantage.Service: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
ua_ubuntu_advantage_service_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _ua_ubuntu_advantage_service_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "com.canonical.UbuntuAdvantage.Service", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) ua_ubuntu_advantage_service_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
ua_ubuntu_advantage_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], UA_TYPE_UBUNTU_ADVANTAGE_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UA_TYPE_UBUNTU_ADVANTAGE_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ua_ubuntu_advantage_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  UaUbuntuAdvantageServiceProxy *proxy = UA_UBUNTU_ADVANTAGE_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
ua_ubuntu_advantage_service_proxy_get_name (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceProxy *proxy = UA_UBUNTU_ADVANTAGE_SERVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ua_ubuntu_advantage_service_proxy_get_description (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceProxy *proxy = UA_UBUNTU_ADVANTAGE_SERVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Description");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ua_ubuntu_advantage_service_proxy_get_entitled (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceProxy *proxy = UA_UBUNTU_ADVANTAGE_SERVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Entitled");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
ua_ubuntu_advantage_service_proxy_get_status (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceProxy *proxy = UA_UBUNTU_ADVANTAGE_SERVICE_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Status");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
ua_ubuntu_advantage_service_proxy_init (UaUbuntuAdvantageServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ua_ubuntu_advantage_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, UA_TYPE_UBUNTU_ADVANTAGE_SERVICE_PROXY, UaUbuntuAdvantageServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ua_ubuntu_advantage_service_interface_info ());
}

static void
ua_ubuntu_advantage_service_proxy_class_init (UaUbuntuAdvantageServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ua_ubuntu_advantage_service_proxy_finalize;
  gobject_class->get_property = ua_ubuntu_advantage_service_proxy_get_property;
  gobject_class->set_property = ua_ubuntu_advantage_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ua_ubuntu_advantage_service_proxy_g_signal;
  proxy_class->g_properties_changed = ua_ubuntu_advantage_service_proxy_g_properties_changed;

  ua_ubuntu_advantage_service_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UaUbuntuAdvantageServiceProxyPrivate));
#endif
}

static void
ua_ubuntu_advantage_service_proxy_iface_init (UaUbuntuAdvantageServiceIface *iface)
{
  iface->get_name = ua_ubuntu_advantage_service_proxy_get_name;
  iface->get_description = ua_ubuntu_advantage_service_proxy_get_description;
  iface->get_entitled = ua_ubuntu_advantage_service_proxy_get_entitled;
  iface->get_status = ua_ubuntu_advantage_service_proxy_get_status;
}

/**
 * ua_ubuntu_advantage_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Service.top_of_page">com.canonical.UbuntuAdvantage.Service</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_service_proxy_new_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ua_ubuntu_advantage_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Service", NULL);
}

/**
 * ua_ubuntu_advantage_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ua_ubuntu_advantage_service_proxy_new().
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageService *
ua_ubuntu_advantage_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_SERVICE (ret);
  else
    return NULL;
}

/**
 * ua_ubuntu_advantage_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Service.top_of_page">com.canonical.UbuntuAdvantage.Service</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageService *
ua_ubuntu_advantage_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Service", NULL);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_SERVICE (ret);
  else
    return NULL;
}


/**
 * ua_ubuntu_advantage_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ua_ubuntu_advantage_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ua_ubuntu_advantage_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ua_ubuntu_advantage_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ua_ubuntu_advantage_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Service", NULL);
}

/**
 * ua_ubuntu_advantage_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ua_ubuntu_advantage_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ua_ubuntu_advantage_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageService *
ua_ubuntu_advantage_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_SERVICE (ret);
  else
    return NULL;
}

/**
 * ua_ubuntu_advantage_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ua_ubuntu_advantage_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ua_ubuntu_advantage_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
UaUbuntuAdvantageService *
ua_ubuntu_advantage_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "com.canonical.UbuntuAdvantage.Service", NULL);
  if (ret != NULL)
    return UA_UBUNTU_ADVANTAGE_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * UaUbuntuAdvantageServiceSkeleton:
 *
 * The #UaUbuntuAdvantageServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * UaUbuntuAdvantageServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #UaUbuntuAdvantageServiceSkeleton.
 */

struct _UaUbuntuAdvantageServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ua_ubuntu_advantage_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], UA_TYPE_UBUNTU_ADVANTAGE_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, UA_TYPE_UBUNTU_ADVANTAGE_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ua_ubuntu_advantage_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ua_ubuntu_advantage_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ua_ubuntu_advantage_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ua_ubuntu_advantage_service_skeleton_vtable =
{
  _ua_ubuntu_advantage_service_skeleton_handle_method_call,
  _ua_ubuntu_advantage_service_skeleton_handle_get_property,
  _ua_ubuntu_advantage_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ua_ubuntu_advantage_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ua_ubuntu_advantage_service_interface_info ();
}

static GDBusInterfaceVTable *
ua_ubuntu_advantage_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ua_ubuntu_advantage_service_skeleton_vtable;
}

static GVariant *
ua_ubuntu_advantage_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_ua_ubuntu_advantage_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ua_ubuntu_advantage_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ua_ubuntu_advantage_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ua_ubuntu_advantage_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "com.canonical.UbuntuAdvantage.Service", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _ua_ubuntu_advantage_service_emit_changed (gpointer user_data);

static void
ua_ubuntu_advantage_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _ua_ubuntu_advantage_service_emit_changed (skeleton);
}

static void ua_ubuntu_advantage_service_skeleton_iface_init (UaUbuntuAdvantageServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageServiceSkeleton, ua_ubuntu_advantage_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (UaUbuntuAdvantageServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE, ua_ubuntu_advantage_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (UaUbuntuAdvantageServiceSkeleton, ua_ubuntu_advantage_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE, ua_ubuntu_advantage_service_skeleton_iface_init))

#endif
static void
ua_ubuntu_advantage_service_skeleton_finalize (GObject *object)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 4; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ua_ubuntu_advantage_service_skeleton_parent_class)->finalize (object);
}

static void
ua_ubuntu_advantage_service_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_ua_ubuntu_advantage_service_emit_changed (gpointer user_data)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "com.canonical.UbuntuAdvantage.Service",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_ua_ubuntu_advantage_service_schedule_emit_changed (UaUbuntuAdvantageServiceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
ua_ubuntu_advantage_service_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _ua_ubuntu_advantage_service_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _ua_ubuntu_advantage_service_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
ua_ubuntu_advantage_service_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 4);
  info = (const _ExtendedGDBusPropertyInfo *) _ua_ubuntu_advantage_service_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _ua_ubuntu_advantage_service_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
ua_ubuntu_advantage_service_skeleton_init (UaUbuntuAdvantageServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ua_ubuntu_advantage_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, UA_TYPE_UBUNTU_ADVANTAGE_SERVICE_SKELETON, UaUbuntuAdvantageServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 4);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_STRING);
}

static const gchar *
ua_ubuntu_advantage_service_skeleton_get_name (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ua_ubuntu_advantage_service_skeleton_get_description (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ua_ubuntu_advantage_service_skeleton_get_entitled (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
ua_ubuntu_advantage_service_skeleton_get_status (UaUbuntuAdvantageService *object)
{
  UaUbuntuAdvantageServiceSkeleton *skeleton = UA_UBUNTU_ADVANTAGE_SERVICE_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
ua_ubuntu_advantage_service_skeleton_class_init (UaUbuntuAdvantageServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ua_ubuntu_advantage_service_skeleton_finalize;
  gobject_class->get_property = ua_ubuntu_advantage_service_skeleton_get_property;
  gobject_class->set_property = ua_ubuntu_advantage_service_skeleton_set_property;
  gobject_class->notify       = ua_ubuntu_advantage_service_skeleton_notify;


  ua_ubuntu_advantage_service_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ua_ubuntu_advantage_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ua_ubuntu_advantage_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ua_ubuntu_advantage_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ua_ubuntu_advantage_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (UaUbuntuAdvantageServiceSkeletonPrivate));
#endif
}

static void
ua_ubuntu_advantage_service_skeleton_iface_init (UaUbuntuAdvantageServiceIface *iface)
{
  iface->get_name = ua_ubuntu_advantage_service_skeleton_get_name;
  iface->get_description = ua_ubuntu_advantage_service_skeleton_get_description;
  iface->get_entitled = ua_ubuntu_advantage_service_skeleton_get_entitled;
  iface->get_status = ua_ubuntu_advantage_service_skeleton_get_status;
}

/**
 * ua_ubuntu_advantage_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-com-canonical-UbuntuAdvantage-Service.top_of_page">com.canonical.UbuntuAdvantage.Service</link>.
 *
 * Returns: (transfer full) (type UaUbuntuAdvantageServiceSkeleton): The skeleton object.
 */
UaUbuntuAdvantageService *
ua_ubuntu_advantage_service_skeleton_new (void)
{
  return UA_UBUNTU_ADVANTAGE_SERVICE (g_object_new (UA_TYPE_UBUNTU_ADVANTAGE_SERVICE_SKELETON, NULL));
}

