<?php
/***************************************************************
*  Copyright notice
*  
*  (c) 1999-2001 Kasper Skaarhoj (kasper@curbysoft.dk)
*  All rights reserved
*
*  This script is part of the Typo3 project. The Typo3 project is 
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
* 
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*  A copy is found in the textfile GPL.txt and important notices to the license 
*  from the author is found in LICENSE.txt distributed with these scripts.
*
* 
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/** 
 * Module: Photo Marathon user functions
 *
 * @author	Kasper Skaarhoj <kasper@typo3.com>
 */
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 *
 *
 *   86: class user_photomarathon 
 *   96:     function showMarathonCategory($dummy, $conf)	
 *  196:     function showPreviewImage($dummy,$conf)	
 *  237:     function processDataArray($dataArr,$conf)	
 *
 * TOTAL FUNCTIONS: 3
 * (This index is automatically created/updated by the extension "extdeveval")
 *
 */
 
 
 

 
// ***************************************
// ***         W A R N I N G           ***
// ***************************************
//  This script calls Typo3 internal 
//  functions (eg. $this->cObj->...) 
//  and is therefore covered by GPL
//  because only GPL licensed code
//  may depend on other GPL code.
//    This is a warning, because 
//  anything you may code that does the 
//  same (eg. makes calls to Typo3
//  functions) will also be legal only
//  under GPL! Just keep that in mind!
//  ... but please go ahead then and
//  share your work with us!
// ***************************************
 
 
 
 



 
 
 
 
/**
 * This class has functions which is used to display the Photo Marathon example
 * 
 * @author	Kasper Skaarhoj <kasper@typo3.com>
 * @package TYPO3
 * @subpackage user_photomarathon
 * @internal
 */
class user_photomarathon {
	var $cObj;	// This is set to a copy of the parent cObj calling this function!

	/**
	 * Renders the list of images in the marathon
	 * 
	 * @param	string		$dummy is only a dummy variable which is sent for compatibility with the the function call in stdWrap. But as a cObject is has no significance.
	 * @param	array		TypoScript configuration sent to the script
	 * @return	string		HTML content
	 */
	function showMarathonCategory($dummy, $conf)	{
		//	debug($conf);
		//	debug($this->cObj->data);
		
			// Getting parameters from the tt_content record 'Parameters' field:
		$parameterArray = $this->cObj->processParams($this->cObj->data['bodytext']);
		
			// The parameter 'categoryPid' determines which folder to look up for the images. We check that this page id has the parent id 137 of the 'uploads' page.
		$catPid = $parameterArray['categoryPid'];
		$pageRec = $GLOBALS['TSFE']->sys_page->getRawRecord('pages',$catPid);
		if ($pageRec['pid']==137)	{	// Page is ok!
				// Prepare image configuration for the IMAGE cObject in "imageConf." AND override the file parameter with the correct filename
			$imgConf = $conf['imageConf.'];
			unset($imgConf['file.']['import']);	// Unset if anything set from TS
			unset($imgConf['file.']['import.']);	// Unset if anything set from TS
			$imgConf['file'] = '';	// Set empty for now...

				// Print header:
			$content.='<h2>Category "'.htmlspecialchars($pageRec['title']).'"</h2>';
			
				// Select the records:
				// Notice that we select all records which has the pid of the category - which means 'all photo-marathon records on the category page'
				// In addition we add a VERY IMPORTANT extension to the query which you should always use: 'enableFields'
				// The concept of 'enableFields' is that this function returns an AND-part for the query which eliminates selection of all records from the table which are marked-deleted, hidden, access-restricted or has a start- and/or endtime. This is all based on the setting of the TCA array!
			$query = 'SELECT * FROM user_photomarathon WHERE pid='.$catPid.$this->cObj->enableFields('user_photomarathon');
			//debug($query);	// Un-comment this line is you would like to see how the query looks for debug-purposes
			$res = mysql(TYPO3_db,$query);
			
				// Render records:
			$accumCode=array();
			$fe_userCacheArray=array();	// Used to cache fe_users information
			while($row = mysql_fetch_assoc($res))	{
				//debug($row);	// Un-comment this line to see the content of the record selected.
					// Get information about the user who owns the image. The id of the user is in $row['fe_cruser_id']
				if (!isset($fe_userCacheArray[$row['fe_cruser_id']]))	{	// Check the fe_userCache array first and if not set, select the user from database
						// Get user:
					$fe_userCacheArray[$row['fe_cruser_id']] = $GLOBALS['TSFE']->sys_page->checkRecord('fe_users',$row['fe_cruser_id']);
						// If no user was returned, set the cache to blank.
					if (!is_array($fe_userCacheArray[$row['fe_cruser_id']]))	{$fe_userCacheArray[$row['fe_cruser_id']]='';}
				}
				if (is_array($fe_userCacheArray[$row['fe_cruser_id']]))	{	// ONLY IF there was a user associated with the image, we proceed. 
						// Explode the image list, extract the filenames, render the images according to the imageConf. configuration.
					$imgArr = explode(',',$row['images']);
					$imgCodeArray=array();	// This is used to accumulate the HTML-code for the images
					reset($imgArr);
					while(list(,$filename)=each($imgArr))	{
							// setting the path of the image
						$theImageFile = 'uploads/photomarathon/'.$filename;
							// Rendering the image
						$imgConf['file']=$theImageFile;	// Overrides with the filename
						$imgCodeArray[] = $this->cObj->IMAGE($imgConf);	// Calls a function in tslib_cObj class which renders the 'imgResource' datatypes!
					}
					
					$accumCode[] = '
					<tr>
						<td bgcolor="#004A88" valign="top" colspan="3"><span class="pm_title">'.htmlspecialchars($row['title']).'</span></td>
					</tr>
					<tr>
						<td valign="top">
							<span class="pm_description">'.nl2br(htmlspecialchars($row['description'])).'</span>
							<br />
							<span class="pm_photographer">
								<div align="center">----------</div><br />
								Photographer:<br /><a href="mailto:'.$fe_userCacheArray[$row['fe_cruser_id']]['email'].'">'.htmlspecialchars($fe_userCacheArray[$row['fe_cruser_id']]['name']).'</a>
							</span>
						</td>
						<td><img src="clear.gif" width="10" height="1" alt="" /></td>
						<td valign="top">'.implode('<br />',$imgCodeArray).'</td>
					</tr>
					<tr>
						<td valign="top" colspan="3"><img src="clear.gif" width="1" height="5" alt="" /></td>
					</tr>';
				}
			}

				// If no images...
			if (!count($accumCode))	{
				$accumCode[] = '
					<tr>
						<td bgcolor="#004A88" valign="top" colspan="3"><span class="pm_title">This category has no images in it yet!</span></td>
					</tr>
				';
			}

				// Add the records rendered to the $content var
			$content.='
				<table border="0" cellpadding="2" cellspacing="1">'.
					implode('',$accumCode).'
				</table>';
		}  else {
			$content = '
				<p>(Error: Category <strong>'.$catPid.'</strong> is invalid!)</p>';
		}
		return $content;
	}


	/**
	 * Renders the preview images used in the upload form.
	 * 
	 * @param	string		$dummy is only a dummy variable which is sent for compatibility with the the function call in stdWrap. But as a cObject is has no significance.
	 * @param	array		TypoScript configuration sent to the script
	 * @return	string		HTML content
	 */
	function showPreviewImage($dummy,$conf)	{
		//	debug($conf);
		//	debug($this->cObj->data);
		
			// Get the configuration for the IMAGE cObject in "imageConf." AND override the file parameter with the correct filename
		$imgConf = $conf['imageConf.'];
		unset($imgConf['file.']['import']);	// Unset if anything set from TS
		unset($imgConf['file.']['import.']);	// Unset if anything set from TS
		$imgConf['file'] = '';	// Set empty for now...
		
			// Explode the image list and extract the filenames
				
		$imgArr = explode(',',$this->cObj->data['images']);
		$imgCodeArray=array();	// This is used to accumulate the HTML-code for the images
		reset($imgArr);
		while(list(,$v)=each($imgArr))	{
				// Because the temp filename is separated from the original filename with a vertical line, |, we must split the value here.
			$parts = explode('|',$v);
			$filename=$parts[0];
			if (count($parts)>1)	{	// If more than one item in the array it's surely a preview file from the typo3temp/ folder
				$theImageFile = 'typo3temp/'.$filename;
			} else {
				$theImageFile = 'uploads/photomarathon/'.$filename;
			}
				// Rendering the image
			$imgConf['file']=$theImageFile;	// Overrides with the filename
			$imgCodeArray[] = $this->cObj->IMAGE($imgConf);	// Calls a function in tslib_cObj class which renders the 'imgResource' datatypes!
		}
		return implode('<br /><br />',$imgCodeArray);
	}
	
	/**
	 * This processes the $dataArr values right after the last evaluation and before they are saved.
	 * 
	 * The purpose of this function is to add the "Common group" with id 5 from the test site to ALL users although that group is not selectable from the list in the front end.
	 * 
	 * @param	mixed		$dataArray should not be an array now if we have set up parseValues.usergroup to 'multiple' - that should have imploded the values from the multiple selector box by now.
	 * @param	array		TypoScript
	 * @return	mixed		Result
	 */
	function processDataArray($dataArr,$conf)	{

			// Checking if key "usergroup" in $dataArray really is an array:
		if (!is_array($dataArr['usergroup']))	{
			$dataArr['usergroup']='5,'.$dataArr['usergroup'];	// Adding user group 5
			$uGArr = t3lib_div::trimExplode(',',$dataArr['usergroup'],1);
			$uGArr = array_unique($uGArr);
			$dataArr['usergroup']=implode(',',$uGArr);	// Cleansing the list of usergroup uid's
		}
//		debug($dataArr);

			// REMEMBER(!) to return the dataArr!!
		return $dataArr;
	}
}
?>