//// [parserUsingConstructorAsIdentifier.ts]
        function define(constructor, instanceMembers, staticMembers) {
            constructor = constructor || function () { };
            PluginUtilities.Utilities.markSupportedForProcessing(constructor);
            if (instanceMembers) {
                initializeProperties(constructor.prototype, instanceMembers);
            }
            if (staticMembers) {
                initializeProperties(constructor, staticMembers);
            }
            return constructor;
        }

        function derive(baseClass, constructor, instanceMembers, staticMembers) {
            if (baseClass) {
                constructor = constructor || function () { };
                var basePrototype = baseClass.prototype;
                constructor.prototype = Object.create(basePrototype);
                PluginUtilities.Utilities.markSupportedForProcessing(constructor);
                Object.defineProperty(constructor.prototype, "constructor", { value: constructor, writable: true, configurable: true, enumerable: true });
                if (instanceMembers) {
                    initializeProperties(constructor.prototype, instanceMembers);
                }
                if (staticMembers) {
                    initializeProperties(constructor, staticMembers);
                }
                return constructor;
            } else {
                return define(constructor, instanceMembers, staticMembers);
            }
        }

        function mix(constructor) {
            constructor = constructor || function () { };
            var i, len;
            for (i = 1, len = arguments.length; i < len; i++) {
                initializeProperties(constructor.prototype, arguments[i]);
            }
            return constructor;
        }

//// [parserUsingConstructorAsIdentifier.js]
function define(constructor, instanceMembers, staticMembers) {
    constructor = constructor || function () {
    };
    PluginUtilities.Utilities.markSupportedForProcessing(constructor);
    if (instanceMembers) {
        initializeProperties(constructor.prototype, instanceMembers);
    }
    if (staticMembers) {
        initializeProperties(constructor, staticMembers);
    }
    return constructor;
}
function derive(baseClass, constructor, instanceMembers, staticMembers) {
    if (baseClass) {
        constructor = constructor || function () {
        };
        var basePrototype = baseClass.prototype;
        constructor.prototype = Object.create(basePrototype);
        PluginUtilities.Utilities.markSupportedForProcessing(constructor);
        Object.defineProperty(constructor.prototype, "constructor", { value: constructor, writable: true, configurable: true, enumerable: true });
        if (instanceMembers) {
            initializeProperties(constructor.prototype, instanceMembers);
        }
        if (staticMembers) {
            initializeProperties(constructor, staticMembers);
        }
        return constructor;
    }
    else {
        return define(constructor, instanceMembers, staticMembers);
    }
}
function mix(constructor) {
    constructor = constructor || function () {
    };
    var i, len;
    for (i = 1, len = arguments.length; i < len; i++) {
        initializeProperties(constructor.prototype, arguments[i]);
    }
    return constructor;
}
