/*
 * twlog:  A basic ham loging program using Motif
 * Copyright (C) 1997->2007 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge. MA 02139,
 * USA. See the COPYING file in this directory.
 *
 * Version: 2.5 -  Oct 2007
 */

#include "twlog.h"

/*
 * build_widgets Function
 * Passed the main shell and the log_res resources array.
 * log_res is used for creating buttons on the option menus.
 */
void build_widgets (Widget logSH, LogRes log_res)
{
   int i, j;
   XmString xs[15];             /* some to spare */

   Widget form1, menuBar, rc1, fileMenu, editMenu, helpMenu;
   Widget datePB, startPB, callsignLabel;
   Widget bandLabel;
   Widget modeLabel;
   Widget pwrLabel;
   Widget rst1Label, rst2Label, endPB, notesLabel;
   Widget dateTF, startTF, callsignTF;
   Widget bandMenu, modeMenu, powerMenu;
   Widget rst1TF, rst2TF, endTF, notesTF;
   Widget popup;


   /* These are used to pass stuff around */
   static Cdata dateCdata, startCdata, endCdata;
   static Widget col_2_wids[10];

   form1 = XtVaCreateWidget ("form1", xmFormWidgetClass, logSH, NULL);
   /*
    * main menu bar.
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("File"); i++;          /* 0 */
   xs[i] = XmStringCreateLocalized ("Edit"); i++;          /* 1 */
   xs[i] = XmStringCreateLocalized ("Help"); i++;          /* 2 */

   menuBar = XmVaCreateSimpleMenuBar (form1, "menuBar",
      XmVaCASCADEBUTTON, xs[0], 'F',
      XmVaCASCADEBUTTON, xs[1], 'E',
      XmVaCASCADEBUTTON, xs[2], 'H',
      NULL);
   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (menuBar,
      XmNleftAttachment, XmATTACH_FORM,
      XmNtopAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNmenuHelpWidget, XtNameToWidget (menuBar, "button_2"),
      NULL);

   /*
    * File Pulldown Menu
    * Creates the pulldown menu for the File button.  All callbacks
    * go to the fileCB() function.  Hangs the address of col_2_wids
    * on the userData of the menu rowColumn.  This will be used by
    * a callbacks.
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("Print Log"); i++;       /* 0 */
   xs[i] = XmStringCreateLocalized ("Ctrl-P"); i++;          /* 1 */
   xs[i] = XmStringCreateLocalized ("New Log"); i++;         /* 2 */
   xs[i] = XmStringCreateLocalized ("Ctrl-N"); i++;          /* 3 */
   xs[i] = XmStringCreateLocalized ("Convert"); i++;         /* 4 */
   xs[i] = XmStringCreateLocalized ("Ctrl-V"); i++;          /* 5 */
   xs[i] = XmStringCreateLocalized ("QRT"); i++;             /* 6 */
   xs[i] = XmStringCreateLocalized ("Ctrl-Q"); i++;          /* 7 */

   fileMenu = XmVaCreateSimplePulldownMenu (menuBar, "fileMenu", 0, fileCB,
      XmVaPUSHBUTTON, xs[0], 'P', "Ctrl<Key>P", xs[1],
      XmVaPUSHBUTTON, xs[2], 'N', "Ctrl<Key>N", xs[3],
      XmVaPUSHBUTTON, xs[4], 'V', "Ctrl<Key>V", xs[5],
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, xs[6], 'Q', "Ctrl<Key>Q", xs[7],
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   } 

   XtVaSetValues (fileMenu,
      XmNtearOffModel, XmTEAR_OFF_ENABLED,
      XmNuserData, &col_2_wids,
      NULL);

   /*
    * Edit Pulldown Menu
    * Creates the pulldown menu for the Edit button.  All callbacks
    * go to the editCB() function.  Hang the address of col_2_wids
    * on the userData of the menu rowColumn.  This will be used by
    * a callbacks.
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("Append"); i++;            /* 0 */
   xs[i] = XmStringCreateLocalized ("Ctrl-A");  i++;           /* 1 */
   xs[i] = XmStringCreateLocalized ("Clear Form"); i++;        /* 2 */
   xs[i] = XmStringCreateLocalized ("Ctrl-C");  i++;           /* 3 */
   xs[i] = XmStringCreateLocalized ("Edit Log");  i++;         /* 4 */
   xs[i] = XmStringCreateLocalized ("Ctrl-E");  i++;           /* 5 */

   editMenu = XmVaCreateSimplePulldownMenu (menuBar, "editMenu", 1, editCB,
      XmVaPUSHBUTTON, xs[0], 'A', "Ctrl<Key>A", xs[1],
      XmVaPUSHBUTTON, xs[2], 'C', "Ctrl<Key>C", xs[3],
      XmVaPUSHBUTTON, xs[4], 'E', "Ctrl<Key>E", xs[5],
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (editMenu,
      XmNtearOffModel, XmTEAR_OFF_ENABLED,
      XmNuserData, &col_2_wids,
      NULL);

   /*
    * Help Pulldown Menu
    * Creates the pulldown menu for the File button. All callbacks go to
    * the helpCB() function.
    */

   i = 0;
   xs[i] = XmStringCreateLocalized ("About"); i++;               /* 0 */
   xs[i] = XmStringCreateLocalized ("Introduction"); i++;        /* 1 */
   xs[i] = XmStringCreateLocalized ("Menu Bar"); i++;            /* 2 */
   xs[i] = XmStringCreateLocalized ("Help Windows"); i++;        /* 3 */
   xs[i] = XmStringCreateLocalized ("Log Entry Form"); i++;      /* 4 */
   xs[i] = XmStringCreateLocalized ("Call Search"); i++;         /* 5 */
   xs[i] = XmStringCreateLocalized ("Log Editor"); i++;          /* 6 */
   xs[i] = XmStringCreateLocalized ("Resources"); i++;           /* 7 */
   xs[i] = XmStringCreateLocalized ("Limits"); i++;              /* 8 */
   xs[i] = XmStringCreateLocalized ("Keyboard"); i++;            /* 9 */

   helpMenu = XmVaCreateSimplePulldownMenu (menuBar, "helpMenu", 2, helpCB,
      XmVaPUSHBUTTON, xs[0], 'A', NULL, NULL,
      XmVaPUSHBUTTON, xs[1], 'I', NULL, NULL,
      XmVaPUSHBUTTON, xs[2], 'M', NULL, NULL,
      XmVaPUSHBUTTON, xs[3], 'H', NULL, NULL,
      XmVaPUSHBUTTON, xs[4], 'F', NULL, NULL,
      XmVaPUSHBUTTON, xs[5], 'S', NULL, NULL,
      XmVaPUSHBUTTON, xs[6], 'E', NULL, NULL,
      XmVaPUSHBUTTON, xs[7], 'R', NULL, NULL,
      XmVaPUSHBUTTON, xs[8], 'L', NULL, NULL,
      XmVaPUSHBUTTON, xs[9], 'K', NULL, NULL,
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (helpMenu,
      XmNtearOffModel, XmTEAR_OFF_ENABLED,
      XmNuserData, &col_2_wids,
      NULL);

   /*
    * Data Entry Form
    * This is the data entry form for the log.  Column 1 (lefthand side
    * of the rowColumn) is pushbuttons and labels.  XS_CONVERT is a res
    * converter macro defined in twlog.h
    */
   rc1 = XtVaCreateWidget ("rc1", xmRowColumnWidgetClass, form1,
      XmNnumColumns, 2,
      XmNadjustLast, TRUE,
      XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNpacking, XmPACK_COLUMN,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, menuBar,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /*
    * Column 1
    */
   datePB = XtVaCreateManagedWidget ("datePB", xmPushButtonWidgetClass, rc1,
      XmNnavigationType, XmTAB_GROUP,
      XS_CONVERT (XmNlabelString, "Date:"),
      NULL);

   startPB = XtVaCreateManagedWidget ("startPB", xmPushButtonWidgetClass, rc1,
      XmNnavigationType, XmTAB_GROUP,
      XS_CONVERT (XmNlabelString, "Start Time:"),
      NULL);

   callsignLabel = XtVaCreateManagedWidget ("callLabel",
      xmLabelWidgetClass, rc1, XS_CONVERT (XmNlabelString, "Call:"),
      NULL);

   bandLabel = XtVaCreateManagedWidget ("bandLabel", xmLabelWidgetClass, rc1,
      XS_CONVERT (XmNlabelString, "Band:"),
      NULL);

   modeLabel = XtVaCreateManagedWidget ("modeLabel", xmLabelWidgetClass, rc1,
      XS_CONVERT (XmNlabelString, "Mode:"),
      NULL);

   pwrLabel = XtVaCreateManagedWidget ("pwrLabel", xmLabelWidgetClass, rc1,
      XS_CONVERT (XmNlabelString, "Power:"),
      NULL);

   rst1Label = XtVaCreateManagedWidget ("rst1Label", xmLabelWidgetClass, rc1,
      XS_CONVERT (XmNlabelString, "His RST:"),
      NULL);

   rst2Label = XtVaCreateManagedWidget ("rst2Label", xmLabelWidgetClass, rc1,
      XS_CONVERT (XmNlabelString, "My RST:"),
      NULL);

   notesLabel = XtVaCreateManagedWidget ("notesLabel", xmLabelWidgetClass, rc1,
      XS_CONVERT (XmNlabelString, "Notes:"),
      NULL);

   endPB = XtVaCreateManagedWidget ("endPB", xmPushButtonWidgetClass, rc1,
      XmNnavigationType, XmTAB_GROUP,
      XS_CONVERT (XmNlabelString, "End Time:"),
      NULL);
   /*
    * End Column 1
    */

   /*
    * Column 2
    * The righthand side of the data entry form is textFields
    * and Option menus.
    */
   dateTF = XtVaCreateManagedWidget ("dateTF", xmTextFieldWidgetClass, rc1,
      XmNmaxLength, 11,
      NULL);

   startTF = XtVaCreateManagedWidget ("startTF", xmTextFieldWidgetClass, rc1,
      XmNmaxLength, 9,
      NULL);

   callsignTF = XtVaCreateManagedWidget ("callTF", xmTextFieldWidgetClass, rc1,
      XmNmaxLength, 10,
      NULL);

   /* 
    * Band Option Menu 
    */
   bandMenu = buildOptionMenus (rc1, log_res.default_band, log_res.bands);

   /*
    * Mode Option Menu
    */
   modeMenu = buildOptionMenus (rc1, log_res.default_mode, log_res.modes);

   /*
    * Power Option Menu
    */
   powerMenu = buildOptionMenus (rc1, log_res.default_power, log_res.power);

   /*
    * RST 1 textfield
    */
   rst1TF = XtVaCreateManagedWidget ("rst1TF", xmTextFieldWidgetClass, rc1,
      XmNmaxLength, 8,
      NULL);

   /*
    * RST 2 textfield
    */
   rst2TF = XtVaCreateManagedWidget ("rst2TF", xmTextFieldWidgetClass, rc1,
      XmNmaxLength, 8,
      NULL);

   /*
    * Notes textfield
    */
   notesTF = XtVaCreateManagedWidget ("notesTF", xmTextFieldWidgetClass, rc1,
      XmNmaxLength, 80,
      NULL);

   endTF = XtVaCreateManagedWidget ("endTF", xmTextFieldWidgetClass, rc1,
      XmNmaxLength, 9,
      NULL);
   /*
    * End Column 2
    */
/*
 * End Data Entry Form
 */

   /*
    * Create popup menu for commonly used functions
    */
   i = 0;
   xs[i] = XmStringCreateLocalized ("TWLOG"); i++;         /* 0 */
   xs[i] = XmStringCreateLocalized ("Append"); i++;        /* 1 */
   xs[i] = XmStringCreateLocalized ("Ctrl-A"); i++;        /* 2 */
   xs[i] = XmStringCreateLocalized ("Clear Form"); i++;    /* 3 */
   xs[i] = XmStringCreateLocalized ("Ctrl-C"); i++;        /* 4 */
   xs[i] = XmStringCreateLocalized ("Edit Log"); i++;      /* 5 */
   xs[i] = XmStringCreateLocalized ("Ctrl-E"); i++;        /* 6 */

   popup = XmVaCreateSimplePopupMenu (form1, "popup", editCB,
      XmVaTITLE, xs[0],
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, xs[1], 'A', "Ctrl<Key>a", xs[2],
      XmVaPUSHBUTTON, xs[3], 'C', "Ctrl<Key>c", xs[4],
      XmVaPUSHBUTTON, xs[5], 'E', "Ctrl<Key>e", xs[6],
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (popup,
      XmNtearOffModel, XmTEAR_OFF_ENABLED, XmNuserData, &col_2_wids,
      NULL);

   /*
    * Initialize argument structs
    * These are passed to some callbacks
    * Note: The notesTF is the last element in the array, but
    * appears as the next to the last widget in the rowColumn.
    */
   dateCdata.TF1 = dateTF;
   dateCdata.TF2 = NULL;
   dateCdata.next = startPB;

   startCdata.TF1 = dateTF;
   startCdata.TF2 = startTF;
   startCdata.next = callsignTF;

   endCdata.TF1 = endTF;
   endCdata.TF2 = NULL;
   endCdata.next = datePB;

   col_2_wids[0] = dateTF;
   col_2_wids[1] = startTF;
   col_2_wids[2] = callsignTF;
   col_2_wids[3] = bandMenu;
   col_2_wids[4] = modeMenu;
   col_2_wids[5] = powerMenu;
   col_2_wids[6] = rst1TF;
   col_2_wids[7] = rst2TF;
   col_2_wids[8] = endTF;
   col_2_wids[9] = notesTF;

   /* Event handler for popup menu */
   XtAddEventHandler (form1, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);

   /*
    * HACK attack 
    * The code within the ifdef should not be needed, but lesstif
    * doesn't seem to propagte events up the tree.  So, everything
    * needs to be registered
    */
#ifdef LESSTIF_VERSION
   printf ("doing hack for lesstif\n");
   for (i = 0; i <= 9; i++)
   {
      XtAddEventHandler (col_2_wids[i], ButtonPressMask, False, popupHandler,
         (XtPointer) popup);
   }
   XtAddEventHandler (menuBar, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (rc1, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (datePB, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (startPB, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (callsignLabel, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (bandLabel, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (modeLabel, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (pwrLabel, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (rst1Label, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (rst2Label, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (notesLabel, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
   XtAddEventHandler (endPB, ButtonPressMask, False, popupHandler,
      (XtPointer) popup);
#endif

   /*
    * Add callbacks
    */
   XtAddCallback (form1, XmNfocusCallback, initCB,
      (XtPointer) NULL);

   /* The first three callbacks registered are for the column 1
    * pushbuttons. The date and end PB's need to know their
    * coresponding textFields, which is passed as client data.  The
    * start PB client data is a pointer to an array holding the IDs of
    * the date and time TFs, so this callback can set both date and
    * start time.
    */
   XtAddCallback (datePB, XmNactivateCallback, dateCB,
      (XtPointer) & dateCdata);
   XtAddCallback (startPB, XmNactivateCallback, startCB,
      (XtPointer) & startCdata);
   XtAddCallback (endPB, XmNactivateCallback, endCB, (XtPointer) & endCdata);

   /*
    * callsign, rst1, rst2 and notes Callbacks - modify/verify and activate.
    * The modify/verify callback changes all letters to upper case.  The
    * activate callback forces a traversal to the next tab group.
    */
   XtAddCallback (callsignTF, XmNmodifyVerifyCallback, callsignCB, NULL);
   XtAddCallback (callsignTF, XmNactivateCallback, callsignCB, NULL);
   XtAddCallback (callsignTF, XmNlosingFocusCallback, callsignCB, NULL);

   /*
    * traverseCB moves to next widget so PB will skip over its text field
    */
   XtAddCallback (rst1TF, XmNactivateCallback, traverseCB, NULL);
   XtAddCallback (rst2TF, XmNactivateCallback, traverseCB, NULL);
   XtAddCallback (notesTF, XmNactivateCallback, traverseCB, NULL);

   /* All the textFields call the focusCB() function.  As a widget gains
    * focus, its cursor is turned on.  As it looses focus, its cursor is
    * turned off. The cursor makes it hard to read the text sometimes,
    * and I got tired of looking at them. So there!
    */
   XtAddCallback (dateTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (dateTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);

   XtAddCallback (startTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (startTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);

   XtAddCallback (callsignTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (callsignTF, XmNlosingFocusCallback, focusCB,
      (XtPointer) NULL);

   XtAddCallback (rst1TF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (rst1TF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);

   XtAddCallback (rst2TF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (rst2TF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);

   XtAddCallback (notesTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (notesTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);

   XtAddCallback (endTF, XmNfocusCallback, focusCB, (XtPointer) NULL);
   XtAddCallback (endTF, XmNlosingFocusCallback, focusCB, (XtPointer) NULL);

   XtManageChild (menuBar);
   XtManageChild (bandMenu);
   XtManageChild (powerMenu);
   XtManageChild (modeMenu);
   XtManageChild (rc1);
   XtManageChild (form1);

   XtVaSetValues (bandMenu, XmNbuttonSet, log_res.default_band, NULL);
}


/*
 * Build Option Menus
 * First count the number of items listed in the labels
 * of the argument.  Next build the Args array to set the
 * properties for the pulldown. Then create the option menu.
 */

Widget buildOptionMenus (Widget parent, int defaultBtn, String *labels)
{
   int i;
   int btn_cnt = 0;
   Widget optionForm, pulldownMenu, pulldownPB, optionMenu;
   Arg args[10];
   Widget defaultWid = 0;       /* widget id of default button */
   XmString xs;                 /* XmString for button names */

   /* count the number of labels */
   while (labels[btn_cnt] != NULL)
   {
      btn_cnt++;
   }

   optionForm = XtVaCreateManagedWidget ("optionForm", xmFormWidgetClass,
      parent,
      NULL);

   i = 0;
   XtSetArg (args[i], XmNnavigationType, XmTAB_GROUP); i++;
   XtSetArg (args[i], XmNentryAlignment, XmALIGNMENT_CENTER); i++;

   pulldownMenu = XmCreatePulldownMenu (optionForm, "Pulldown", args, i);

   for (i = 0; i < btn_cnt; i++)
   {
      xs = XmStringCreateLocalized (labels[i]);   /* convert to XmString */
      pulldownPB = XtVaCreateManagedWidget ("PulldownPB",
         xmPushButtonWidgetClass, pulldownMenu,
         XmNlabelString, xs,
         NULL);
      XmStringFree (xs);                /* free the XmString */

      if (i == defaultBtn)              /* remember this wid if it is      */
      {                                 /* the default btn and use for the */
         defaultWid = pulldownPB;       /* default for the option menu     */
      }
   }

   i = 0;
   XtSetArg (args[i], XmNsubMenuId, pulldownMenu); i++;
   XtSetArg (args[i], XmNmenuHistory, defaultWid); i++; /* default button */

   optionMenu = XmCreateOptionMenu (optionForm, "optionMenu", args, i);

   XtVaSetValues (XmOptionButtonGadget (optionMenu),
      XmNborderWidth, 0,
      NULL);

   XtUnmanageChild (XmOptionLabelGadget (optionMenu));

   return (optionMenu);
}
