<?php

$TWIGSessionIndex = array( "mainGroup",
			"mailGroup", "mailbox", "mail_startmsg", "sortby", "sortbyway", "mailtree", "delete-return",
			"newsGroup",
			"listfeature",
			"contactsGroup",
			"scheduleGroup", "schtodaysdate", "schcurdate", "action-return",
			"meetingsGroup",
			"todoGroup",
			"notesGroup",
			"bookmarksGroup",
			"searchGroup",
			"prefsGroup",
			"helpGroup" );

// News
$TWIGSessionIndex[] = "newsGroup";

// Create reverse-lookup session index
$TWIGSessionRevIndex = array_flip( $TWIGSessionIndex );

	Function TWIGGetContext()
		{
		GLOBAL $config, $c;

		if( isset( $c["f"] ) )
			{
			$context["feature"] = URLDecode( stripslashes( $c["f"] ) );
			if( isset( $c["a"] ) ) { $context["action"] = URLDecode( stripslashes( $c["a"] ) ); } else { $context["action"] = "main"; }
			}
		else
			{
			$context = array( "feature"=>$config["default_feature"], "action"=>"main" );
			}

		return $context;
 		}

	Function TWIGGetSession()
		{
		GLOBAL $s, $TWIGSessionIndex;

   		if( is_array( $s ) )
			{
			while( list( $key, $val ) = each( $s ) )
			 	{
				if( is_numeric( $key ) && $TWIGSessionIndex[$key] ) { $key = $TWIGSessionIndex[$key]; }
   				$session[$key] = URLDecode( stripslashes( $val ) );
				}
			}
		return $session;
 		}

 	Function TWIGSession( $type = "get", $other = "" )
		{
		global $session, $TWIGSessionDefaults, $TWIGSessionRevIndex;

		$tsession = $session;

		$str = "";

		if( $other )
			{
			for( $i=0, $j=count( $other ); $i<$j; ++$i )
				{
				$tsession[$other[$i]["item"]] = $other[$i]["value"];
				}
			}

	 	if( $type == "get" )
			{
			while( list( $key, $val ) = each( $tsession ) )
				{
				if( !isset( $TWIGSessionDefaults[$key] ) || ( $TWIGSessionDefaults[$key] != $val ) )
					{
					if( isset( $TWIGSessionRevIndex[$key] ) ) { $key = $TWIGSessionRevIndex[$key]; }
					$str .= "&amp;s[$key]=" . URLEncode( $val );
					}
				}
			}
		else
			{
			while( list( $key, $val ) = each( $tsession ) )
				{
				if( !isset( $TWIGSessionDefaults[$key] ) || ( $TWIGSessionDefaults[$key] != $val ) )
					{
					if( isset( $TWIGSessionRevIndex[$key] ) ) { $key = $TWIGSessionRevIndex[$key]; }
					$str .= "<input type=\"hidden\" name=\"s[$key]\" value=\"" . URLEncode($val) . "\">\n";
					}
				}
			}

		reset( $session );

		return $str;
 		}

	Function TWIGContext( $type = "get", $feature = "", $action = "" )
		{
		global $context;

		if( $feature ) { $c["f"] = URLEncode( $feature ); } else { $c["f"] = URLEncode( $context["feature"] ); }
		if( $action ) { $c["a"] = URLEncode( $action ); } else { $c["a"] =  URLEncode( $context["action"] ); }

		$str = "";

	 	if( $type == "get" )
			{
			if( $c["f"] != "main" )
				{
				$str .= "&amp;c[f]=" . $c["f"];
				if( $c["a"] != "main" ) { $str .= "&amp;c[a]=" . $c["a"]; }
				}
			}
		else
			{
			if( $c["f"] != "main" )
				{
				$str .= "<input type=\"hidden\" name=\"c[f]\" value=\"" . $c["f"] . "\">\n";
				if( $c["a"] != "main" ) { $str .= "<input type=\"hidden\" name=\"c[a]\" value=\"" . $c["a"] . "\">\n"; }
				}
			}

		return $str;
 		}

	Function TWIGCleanSession()
		{
		return;
		}

	Function TWIGCleanContext()
		{
		return;
		}
?>
