<?php	// TWIG		Header Configuration File ?>
<?php

	$config["brandname"]		= "TWIG";		// This is the name used for the title bar
	$config["fromdomain"]		= "foo.com";		// This is where mail will be sent from
	$config["basedir"]		= "/twig";		// The path of the URL to your TWIG installation
	$config["imgdir"]		= "/twig/images";	// The path to graphics files
	$config["index"]		= "index.php";		// This is what you name the index file
								// Note: index.php can be aliased to the value of $config["basedir"]
								// in apache's httpd.conf, which cleans up the URL area.
	$config["url_timestamp"]	= 0;			// Whether or not to include a timestamp in TWIG's URL's.
								// TWIG pages should not be cached by any standards compliant browser or cache.
								// Enable this only if you have a broken browser or cache that wants to cache TWIG pages anyway.

	$config["auth"]			= "forms";		// Authorization Type (basic|forms|secureform)
								// DO NOT use cookie login handler with secureform.

	$config["use_https"]		= 0;			// Set to 1 to force TWIG to use https
	$config["auth_timeout"]		= 3600;			// Set the auth cookie timeout value, in seconds. Set to 0 for session length cookies
	$config["auth_logout_redirect"]	= "";			// Complete URL to redirect browsers to after they have been logged out
	$config["auth_provider"]	= "imap-new";		// Authorization Method (imap-new|imap|sqltable|mysql|pgsql|ldap|sqlimap|sqlopen|nntp|ibase|imap-limit|oracle|pop3)

	$config["security"]		= "basic";		// Type of security to use (basic|advanced)

	$config["groups"]		= "standard"; 		// What level of group support to use (none|standard|personal|userperms)

	$config["language"] 		= "english"; 		// language file to use (english is the default).
								// language files are in /lib/strings
								// language options are in /features/prefs/modules/global.inc.php3

	$config["spellcheck"]		= "/usr/local/bin/aspell -a"; // Command, including full path and flags, to run a spellcheck (via pipe)

	$config["session_handler"]	= "get2";		// Session handler (get|get2|sqltable|php4session)
	$config["session_expiry"]	= 300;			// How long session records are retained (in seconds)
	$config["login_handler"]	= "cookie";		// Login handler (cookie|sqltable|base64cookie|php4session|session|securecookie.php4session|securecookie.sqltable)

	$config["default_feature"]	= "main";		// Which feature should TWIG load upon login (main|mail|news|contacts|schedule|meetings|todo|notes|bookmarks|preferences|help|groups)
	$config["announcements"]	= "basic";		// Announcements type (basic|advanced)

	$config["timeformat"]["12"]	= "h:i a";		// Format to display time in (12 hour format)
	$config["timeformat"]["24"]	= "H:i";		// Format to display time in (24 hour format)
	$config["longdateformat"]	= "l, F j Y";		// Format to display long dates in
	$config["shortdateformat"]	= "m/d/y";		// Format to display dates in
	$config["firstdayweek"]		= 0;			// 1st day in week, 0=sunday, 1=monday

								// IMAP Mail Server Settings
	$config["imap_servertype"]	= "php-imap";		// Mail system to use (defaults to php-imap) (php-imap|php-pop3)
	$config["imap_server"]		= "localhost";		// IMAP Server Host (defaults to localhost)
	$config["imap_port"]		= "143/notls";		// IMAP Server Port (defaults to 143)
	$config["imap_path"]		= "";			// IMAP Mail Path (defaults to home dir)
								// Set to "INBOX." for Cyrus and Courier IMAP servers.
	$config["mail_folder_delimiter"]= "/";			// Character that divides hierarchical levels of folder names ("/" for UofW IMAP, "." for Cyrus and Courier)
	$config["inboxmax"]		= 10485760;		// Maximum recommended INBOX size (defaults to 10 MB)
	$config["mailboxmax"]		= 31457280;		// Maximum recommended mailbox size (defaults to 30 MB)

	$config["mail_sender"]		= "relay";		// How to we deal with outgoing mail? (internal/relay/imap-mail)
	$config["smtp_server"]		= "localhost";		// SMTP Relay server to send mail through
	$config["smtp_port"]		= "25";			// SMTP Relay server port to send mail through
	$config["smtp_clientip"]	= 0;			// Add "X-Client-IP: <ip address of web browser>" to SMTP headers.  (0|1)

	$config["news_server"]		= "news";		// News Server Host (defaults to localhost)
	$config["news_port"]		= "119";		// News Server Port (defaults to 119)


//	$vhosts["<server_name>"]	= "config/<server_name>"; // Setup support for virtual hosts

								// Non-overridable feature disables
	$disabled["global_goto"]	= 0;			// Disable the goto box at the bottom of page (1=yes, 0=no)
	$disabled["mail_showattach"] 	= 1;			// Disable extra message info in mailbox view (off for performance boost)
	$disabled["mail_configfrom"]	= 1;			// Disable the user's ability to change their from address
	$disabled["mail_folder_graph"]	= 0;			// Disable the mail folder capacity graph
	$disabled["search"]		= 0;			// Disable the Search feature
	$disabled["reminders"]		= 1;			// Disable the schedule reminders (currently in beta)
								// See docs/reminders.txt before enabling

	$config["debug"]		= 0;			// Set to 10 view debugging output in some parts of TWIG
								// Set to 20 to view more detailed info, but may conflict with cookie setting,
								//     if you need this level you should set the login handler to session
								// Set to 30 to see lots of extra information that is typically useless :)
//	$config["debug_users"]["<username>"] = 0;		// Remove the '//' and replace '<username>' with a real username to set debug levels for a specific user.
?>
