<!--
  Stylesheet to convert Twitter user timelines to RSS.

  Copyright (C) 2013-2014  Antonio Ospite <ao2@ao2.it>

  This file is part of tweeper.

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:php="http://php.net/xsl"
    xsl:extension-element-prefixes="php"
    exclude-result-prefixes="php">

    <xsl:param name="generateEnclosure"/>

    <xsl:output method="xml" indent="yes"/>

    <xsl:variable name="BaseURL">
        <xsl:text>https://twitter.com</xsl:text>
    </xsl:variable>

    <xsl:template match="a[@data-expanded-url]">
        <xsl:value-of disable-output-escaping="yes" select="php:function('Tweeper::generate_enclosure', string(./@data-expanded-url))"/>
    </xsl:template>

    <xsl:variable name="screen-name" select="//div[@class='user-actions btn-group not-following ']/@data-screen-name"/>

    <xsl:template match="//li[@data-item-id and @data-item-type='tweet']">
        <xsl:variable name="user-name" select=".//div[contains(@class, 'js-stream-tweet')]/@data-screen-name"/>
        <xsl:variable name="item-content" select=".//p[contains(@class, 'js-tweet-text')]"/>
        <xsl:variable name="item-permalink" select="concat($BaseURL, .//div[@data-permalink-path]/@data-permalink-path)"/>
        <item>
            <title>
                <xsl:value-of select="concat($user-name, ': ', $item-content)"/>
            </title>
            <link>
                <xsl:value-of select="$item-permalink"/>
            </link>
            <guid>
                <xsl:value-of select="$item-permalink"/>
            </guid>
            <pubDate>
                <xsl:variable name="timestamp" select=".//span[contains(@class, 'js-short-timestamp')]/@data-time"/>
                <xsl:value-of select="php:functionString('Tweeper::epoch_to_gmdate', number($timestamp))"/>
            </pubDate>
            <description>
                <xsl:value-of select="concat($user-name, ': ')"/>
                <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                <xsl:copy-of select="$item-content/node()"/>
                <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
            </description>
            <xsl:if test="$generateEnclosure = 1">
                <xsl:apply-templates select="$item-content//a[@data-expanded-url]"/>
            </xsl:if>
        </item>
    </xsl:template>

    <xsl:template match="/">
        <xsl:variable name="channel-title">
            <xsl:choose>
                <xsl:when test="$screen-name != ''">
                    <xsl:value-of select="concat('Twitter / ', $screen-name)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('Twitter / ', normalize-space(//h1[1]))"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="channel-link" select="//link[@rel='canonical']/@href"/>

        <rss version="2.0">
            <xsl:attribute name="xml:base"><xsl:value-of select="$BaseURL" /></xsl:attribute>
            <channel>
                <generator>Tweeper</generator>
                <title>
                    <xsl:value-of select="$channel-title"/>
                </title>
                <link>
                    <xsl:value-of select="$channel-link"/>
                </link>
                <description>
                    <xsl:value-of select="normalize-space(//div[@class='ProfileHeaderCard'])"/>
                </description>
                <image>
                    <title>
                        <xsl:value-of select="$channel-title"/>
                    </title>
                    <link>
                        <xsl:value-of select="$channel-link"/>
                    </link>
                    <url>
                        <xsl:value-of select="//a[contains(@class, 'profile-picture media-thumbnail')]/@href"/>
                    </url>
                </image>
                <xsl:apply-templates select="//ol[@id='stream-items-id']/li[@data-item-id and @data-item-type='tweet']"/>
            </channel>
        </rss>
    </xsl:template>
</xsl:stylesheet>
