/*
  Originally generated by Fast Light User Interface Designer (fluid) v. 1.0104

  Torsten Giebl <wizard@turricane.org>
  Jan Wynholds
  Bill Kendrick <bill@newbreedsoftware.com>

  ??? - October 2, 2004
*/

#include <libintl.h>
#include "tuxpaint-config2.h"
#include <FL/fl_ask.H>
#include <FL/fl_message.H>
#include <FL/Fl.H>
#include <FL/Fl_File_Chooser.H>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <errno.h>
#include "version.h"
#include "about.h"

/* Current build stuff doesn't deal with gettext; jdrake 2004-10-02 */
#ifdef __APPLE__
#define gettext(text) text
#endif


// Win32 specific stuff to help set the window icon
#ifdef WIN32
#include "resource.h"           // contains IDI_ICON1
extern HINSTANCE fl_display;    // hInstance on win32 platform
#endif

//dont think save_conf will work for win32...
//need to redo with #IFDEF precompiler definitions and better writing

bool status_chng=0;

char conf_filename[256];

#define NUM_LANGS 45
#define LANG_NAME 0
#define LANG_CODE 1

const char * langs[NUM_LANGS][2] = {
	{"(Use system's setting)", "default"},
	{"Afrikaans", "afrikaans"},
	{"Basque", "basque"},
	{"Belarusian", "belarusian"},
	{"Breton", "breton"},
	{"Catalan", "catalan"},
        {"Chinese (Simplified)", "simplified-chinese"},
        {"Chinese (Traditional)", "traditional-chinese"},
	{"Croatian", "croatian"},
	{"Czech", "czech"},
	{"Danish", "danish"},
	{"Dutch", "dutch"},
	{"English (USA)", "american-english"},
	{"English (British)", "british"},
	{"Finnish", "finnish"},
	{"French", "french"},
	{"German", "german"},
	{"Greek", "greek"},
	{"Hebrew", "hebrew"},
	{"Hindi", "hindi"},
	{"Hungarian", "hungarian"},
	{"Icelandic", "icelandic"},
	{"Indonesian", "indonesian"},
	{"Italian", "italian"},
	{"Japanese", "japanese"},
	{"Korean", "korean"},
	{"Lithuanian", "lithuanian"},
	{"Malay", "malay"},
	{"Norwegian Bokml", "bokmal"},
	{"Norwegian Nynorsk", "nynorsk"},
	{"Polish", "polish"},
	{"Portuguese (Portugal)", "portuguese"},
        {"Portuguese (Brazilian)", "brazilian-portuguese"},
	{"Romanian", "romanian"},
	{"Russian", "russian"},
	{"Serbian", "serbian"},
	{"Slovak", "slovak"},
	{"Slovenian", "slovenian"},
	{"Spanish", "spanish"},
	{"Swedish", "swedish"},
	{"Tamil", "tamil"},
	{"Turkish", "turkish"},
	{"Vietnamese", "vietnamese"},
	{"Walloon", "walloon"},
	{"Welsh", "welsh"}};


void construct_conf_filename(void)
{
#if defined(WIN32) || defined(__BEOS__)
  /* Windows and BeOS: Use a "tuxpaint.cfg" file: */

  strcpy(conf_filename, "tuxpaint.cfg");

#else

  /* Linux and other Unixes:  Use 'rc' style (~/.tuxpaintrc) */

  if (getenv("HOME") != NULL)
  {
    snprintf(conf_filename, sizeof(conf_filename),
	     "%s/.tuxpaintrc", getenv("HOME"));
  }
  else
  {
    strcpy(conf_filename, "tuxpaint.cfg");
  }

#endif
}


void save_conf(void)
{
   FILE *fd;
   char *flg="w";

   construct_conf_filename();

   fd = fopen(conf_filename,flg);

   if (fd == NULL)
      {
        fl_message("Cannot write %s: %s",conf_filename, strerror(errno));
        return;
      }

   fprintf(fd,"# Generated by tuxpaint-config version " VER_VERSION "\n");

   /* Video & Sound: */
   /* -------------- */

   /* Video: */
   if ((CHKBUT_fulls_isdef())==0)
      fprintf(fd,"fullscreen=yes\n");
   if ((RNDBUT_scrnsz_isdef())==0)
      fprintf(fd,"800x600=yes\n");

   /* Sound: */
   if (CHECKBUTTON_soundeffects->value()==0)
      fprintf(fd,"nosound=yes\n");


   /* Mouse & Keyboard: */
   /* ----------------- */

   /* Mouse: */
   if ((CHKBUT_fancycursors_isdef())==0)
      fprintf(fd,"nofancycursors=yes\n");
   if ((CHKBUT_grabmouse_isdef())==0)
      fprintf(fd,"grab=yes\n");
   if ((CHKBUT_mousewheelsup_isdef())==0)
      fprintf(fd,"nowheelmouse=yes\n");

   /* Keyboard: */
   if (CHECKBUTTON_enablekbd->value()==0)
      fprintf(fd,"noshortcuts=yes\n");
// if ((CHKBUT_xxx_isdef())==0)
//    fprintf(fd,"keyboard=yes\n");


   /* Simplification: */
   /* --------------- */

   /* Interface: */
   if (CHECKBUTTON_disableshaperotation->value()==1)
      fprintf(fd,"simpleshapes=yes\n");
   if ((CHKBUT_smploutlns_isdef())==0)
      fprintf(fd,"outlines=yes\n");
   if ((CHKBUT_showUConly_isdef())==0)
      fprintf(fd,"uppercase=yes\n");

   /* Control: */
   if ((CHKBUT_disablequit_isdef())==0)
      fprintf(fd,"noquit=yes\n");
   if (CHECKBUTTON_disablestampstool->value()==1)
      fprintf(fd,"nostamps=yes\n");
   if (CHECKBUTTON_disablestampcontrols->value()==1)
      fprintf(fd,"nostampcontrols=yes\n");


   /* Locale: */
   /* ------- */

   if(CHOICE_language->value()!=0)
      fprintf(fd,"lang=%s\n",langs[CHOICE_language->value()][LANG_CODE]);
   if ((CHKBUT_mirstamps_isdef())==0)
      fprintf(fd,"mirrorstamps=yes\n");


   /* Printing: */
   /* --------- */

   /* Print Permissions: */
   if ((CHKBUT_allowprint_isdef())==0)
      fprintf(fd,"noprint=yes\n");
   if ((VALINP_printdel_isdef())==0)
      fprintf(fd,"printdelay=%d\n",(int) VALUEINPUT_printdelay->value());

   /* Print Command: */
   if (strlen(TEXTINPUT_printcmd->value()) > 0)
   {
     if (CHECKBUTTON_usealtprintcmd -> value() == 1)
       fprintf(fd,"printcommand=%s\n",TEXTINPUT_printcmd->value());
     else
       fprintf(fd,"# printcommand=%s\n",TEXTINPUT_printcmd->value());
   }


   /* Saving: */
   /* ------- */

   /* Save Over Earlier Work: */
   if (ROUNDBUTTON_alwaysoverwriteolderversion->value()==1)
     fprintf(fd,"saveover=yes\n");
   else if (ROUNDBUTTON_alwayssavenewpicture->value()==1)
      fprintf(fd,"saveover=no\n");

   /* Save Directory: */
   if (strlen(FILEINPUT_alternatesavedir->value()) > 0)
   {
     if ((CHKBUT_altsavedir_isdef())==0)
       fprintf(fd,"savedir=%s\n",FILEINPUT_alternatesavedir->value());
     else
       fprintf(fd,"# savedir=%s\n",FILEINPUT_alternatesavedir->value());
   }

   fclose(fd);
  
   BUTTON_apply->deactivate();
   status_chng=0;

/*
   FIXME: Add "--nosave" option to UI and save/load routines
   FIXME: Add "--keyboard" option to UI and save/load routines
*/

}



void load_conf(void)
{
   FILE *fd;
   char *flg="r";
   char line[256];

   construct_conf_filename();

   fd = fopen(conf_filename,flg);

   if (fd != NULL)
   {
     do
     {
       fgets(line, sizeof(line), fd);
       
       if (!feof(fd))
       {
	 /* Trim EOL char(s): */
	       
	 while (strlen(line) > 0 &&
		(line[strlen(line) - 1] == '\r' ||
		 line[strlen(line) - 1] == '\n'))
	 {
	   line[strlen(line) - 1] = '\0';
	 }

	 
	 /* Determine what option it is, and if we should alter the UI
	    to correspond */
	
	 /* Video & Sound: */
	 if (strcmp(line, "fullscreen=yes") == 0)
	   CHECKBUTTON_fullscreen->value(1);
	 else if (strcmp(line, "800x600=yes") == 0)
	 {
	   ROUNDBUTTON_640x480->value(0);
	   ROUNDBUTTON_800x600->value(1);
	 }
	 else if (strcmp(line, "nosound=yes") == 0)
	   CHECKBUTTON_soundeffects->value(0);
	 
	 /* Mouse & Keyboard: */
	 else if (strcmp(line, "nofancycursors=yes") == 0)
	   CHECKBUTTON_fancycursorshapes->value(0);
	 else if (strcmp(line, "grab=yes") == 0)
	   CHECKBUTTON_grabmousepointer->value(1);
	 else if (strcmp(line, "nowheelmouse=yes") == 0)
	   CHECKBUTTON_mousewheelsupport->value(0);
	 else if (strcmp(line, "noshortcuts=yes") == 0)
	   CHECKBUTTON_enablekbd->value(0);

	 /* Simplifications: */
	 else if (strcmp(line, "simpleshapes=yes") == 0)
	   CHECKBUTTON_disableshaperotation->value(1);
	 else if (strcmp(line, "outlines=yes") == 0)
	   CHECKBUTTON_simpleshapeoutlines->value(1);
	 else if (strcmp(line, "uppercase=yes") == 0)
	   CHECKBUTTON_showuppercasetextonly->value(1);
	 else if (strcmp(line, "noquit=yes") == 0)
	   CHECKBUTTON_disablequitbutton->value(1);
	 else if (strcmp(line, "nostamps=yes") == 0)
	   CHECKBUTTON_disablestampstool->value(1);
	 else if (strcmp(line, "nostampcontrols=yes") == 0)
	   CHECKBUTTON_disablestampcontrols->value(1);

	 /* Locale: */
	 else if (strstr(line, "lang=") == line)
	 {
	   char * lang;
	   int i;
	   
	   lang = strstr(line, "lang=") + strlen("lang=");
	   
	   for (i = 0; i < NUM_LANGS; i++)
	   {
	     if (strcmp(lang, langs[i][LANG_CODE]) == 0)
	       CHOICE_language->value(i);
	   }
	 }
	 else if (strcmp(line, "mirrorstamps=yes") == 0)
	   CHECKBUTTON_mirrorstamps->value();

	 /* Printing: */
	 else if (strcmp(line, "noprint=yes") == 0)
	   CHECKBUTTON_allowprinting->value(0);
	 else if (strstr(line, "printdelay=") == line)
	 {
	   VALUEINPUT_printdelay->value(atoi(strstr(line, "printdelay=") +
				             strlen("printdelay=")));
	 }
	 else if (strstr(line, "printcommand=") != NULL)
	 {
	   TEXTINPUT_printcmd->value(strstr(line, "printcommand=") +
			             strlen("printcommand="));

	   if (strstr(line, "printcommand=") == line)
	   {
             /* Active! */
		   
	     CHECKBUTTON_usealtprintcmd->value(1);
	     TEXTINPUT_printcmd->activate();
	   }
	   else
	   {
             /* Inactive! */
		   
	     CHECKBUTTON_usealtprintcmd->value(0);
	     TEXTINPUT_printcmd->deactivate();
	   }
	 }
	 
	 /* Saving: */
	 else if (strcmp(line, "saveover=ask") == 0)
	 {
           ROUNDBUTTON_askbeforeoverwriting->value(1);
           ROUNDBUTTON_alwaysoverwriteolderversion->value(0);
           ROUNDBUTTON_alwayssavenewpicture->value(0);
	 }
	 else if (strcmp(line, "saveover=yes") == 0)
	 {
           ROUNDBUTTON_askbeforeoverwriting->value(0);
           ROUNDBUTTON_alwaysoverwriteolderversion->value(1);
           ROUNDBUTTON_alwayssavenewpicture->value(0);
	 }
	 else if (strcmp(line, "saveover=no") == 0)
	 {
           ROUNDBUTTON_askbeforeoverwriting->value(0);
           ROUNDBUTTON_alwaysoverwriteolderversion->value(0);
           ROUNDBUTTON_alwayssavenewpicture->value(1);
	 }
	 else if (strstr(line, "savedir=") != NULL)
	 {
	   FILEINPUT_alternatesavedir->value(strstr(line, "savedir=") +
			                     strlen("savedir="));

	   if (strstr(line, "savedir=") == line)
	   {
             /* Active! */
		   
	     CHECKBUTTON_usealternatesavedir->value(1);
	     FILEINPUT_alternatesavedir->activate();
	     BUTTON_browsealternatesavedir->activate();
	   }
	   else
	   {
             /* Inactive! */
		   
	     CHECKBUTTON_usealternatesavedir->value(0);
	     FILEINPUT_alternatesavedir->deactivate();
	     BUTTON_browsealternatesavedir->deactivate();
	   }
	 }
       }
     }
     while (!feof(fd));
   }
}

Fl_Double_Window *WINDOW_tpc=(Fl_Double_Window *)0;

Fl_Tabs *TAB_alltabs=(Fl_Tabs *)0;

Fl_Group *TABE_about=(Fl_Group *)0;
Fl_Group *GROUP_abouttpc=(Fl_Group *)0;
Fl_Text_Display *TEXTOUTPUT_abouttext=(Fl_Text_Display *)0;
Fl_Text_Buffer *TEXTBUFFER_abouttext = new Fl_Text_Buffer();

Fl_Group *TABE_videoandsound=(Fl_Group *)0;

Fl_Group *GROUP_video=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_fullscreen=(Fl_Check_Button *)0;
Fl_Group *GROUP_resolution=(Fl_Group *)0;
Fl_Round_Button *ROUNDBUTTON_640x480=(Fl_Round_Button *)0;
Fl_Round_Button *ROUNDBUTTON_800x600=(Fl_Round_Button *)0;

Fl_Group *GROUP_sound=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_soundeffects=(Fl_Check_Button *)0;

Fl_Group *TABE_mouseandkeyboard=(Fl_Group *)0;
Fl_Group *GROUP_mouse=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_fancycursorshapes=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_grabmousepointer=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_mousewheelsupport=(Fl_Check_Button *)0;

Fl_Group *GROUP_keyboard=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_enablekbd=(Fl_Check_Button *)0;

Fl_Group *TABE_simplification=(Fl_Group *)0;
Fl_Group *GROUP_interfacesimpl=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_disableshaperotation=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_simpleshapeoutlines=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_showuppercasetextonly=(Fl_Check_Button *)0;
Fl_Group *GROUP_controlsimpl=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_disablequitbutton=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_disablestampstool=(Fl_Check_Button *)0;
Fl_Check_Button *CHECKBUTTON_disablestampcontrols=(Fl_Check_Button *)0;

Fl_Group *TABE_locale=(Fl_Group *)0;
Fl_Group *GROUP_locale=(Fl_Group *)0;
Fl_Choice *CHOICE_language=(Fl_Choice *)0;
Fl_Check_Button *CHECKBUTTON_mirrorstamps=(Fl_Check_Button *)0;

Fl_Group *TABE_printing=(Fl_Group *)0;
Fl_Group *GROUP_printperms=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_allowprinting=(Fl_Check_Button *)0;
Fl_Value_Input *VALUEINPUT_printdelay=(Fl_Value_Input *)0;
Fl_Box *LABEL_seconds=(Fl_Box *)0;
Fl_Group *GROUP_printcmd=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_usealtprintcmd=(Fl_Check_Button *)0;


static void cb_CHECKBUTTON_usealtprintcmd(Fl_Check_Button*, void*) {
  if (CHECKBUTTON_usealtprintcmd -> value () == 1)
{
	TEXTINPUT_printcmd -> activate   ();
}
else
{
	TEXTINPUT_printcmd -> deactivate ();
};
  status_chng=1;
  BUTTON_apply->activate();
}

Fl_Input *TEXTINPUT_printcmd=(Fl_Input *)0;

Fl_Group *TABE_saving=(Fl_Group *)0;

Fl_Group *GROUP_saveover=(Fl_Group *)0;
Fl_Round_Button *ROUNDBUTTON_askbeforeoverwriting=(Fl_Round_Button *)0;
Fl_Round_Button *ROUNDBUTTON_alwaysoverwriteolderversion=(Fl_Round_Button *)0;
Fl_Round_Button *ROUNDBUTTON_alwayssavenewpicture=(Fl_Round_Button *)0;
Fl_Group *GROUP_savedir=(Fl_Group *)0;
Fl_Check_Button *CHECKBUTTON_usealternatesavedir=(Fl_Check_Button *)0;

static void cb_CHECKBUTTON_usealternatesavedir(Fl_Check_Button*, void*) {
  if (CHECKBUTTON_usealternatesavedir -> value () == 1)
{
	FILEINPUT_alternatesavedir    -> activate   ();
	BUTTON_browsealternatesavedir -> activate   ();
}
else
{
	FILEINPUT_alternatesavedir    -> deactivate ();
	BUTTON_browsealternatesavedir -> deactivate ();
};
  status_chng=1;
  BUTTON_apply->activate();
}

Fl_File_Input *FILEINPUT_alternatesavedir=(Fl_File_Input *)0;

static void cb_BUTTON_browsealternatesavedir(Fl_Button*, void*) {
    const char *dirname="\n";
    dirname = fl_dir_chooser(gettext("Directory ?"),"");
    fl_file_chooser_callback(0);
    FILEINPUT_alternatesavedir->value(dirname);
    WINDOW_tpc->show();
    BUTTON_apply->activate();
    status_chng=1;
}

Fl_Button *BUTTON_browsealternatesavedir=(Fl_Button *)0;

Fl_Button *BUTTON_apply=(Fl_Button *)0;

void cb_BUTTON_apply(Fl_Button*, void*) {
  save_conf();
}

static void cb_BUTTON_reset(Fl_Button*, void*) {
  DEF_videoandsound();
  DEF_mouseandkeyboard();
  DEF_simplification();
  DEF_locale();
  DEF_printing();
  DEF_saving();
  WINDOW_tpc -> show();
  BUTTON_apply->deactivate();
  status_chng=0;
}

Fl_Button *BUTTON_reset=(Fl_Button *)0;

Fl_Button *BUTTON_defaults=(Fl_Button *)0;
Fl_Button *BUTTON_quit=(Fl_Button *)0;

static void cb_BUTTON_defaults(Fl_Button*, void*) {
  CB_SetActualTabToDefaults ();
  WINDOW_tpc -> show ();
}

static void cb_status_chng(Fl_Widget*, void*) {
  status_chng=1;
  BUTTON_apply->activate();
}

void confirm_exit_cb(Fl_Widget *, void *) {
  if (status_chng)
  {
    if (fl_ask(gettext("Quit without applying changes?")))
        exit(0);
  }
  else
  {
    exit(0);
  }
}

Fl_Double_Window* Show_TPC_Window() {
  Fl_Double_Window* w;
  { Fl_Double_Window* o = WINDOW_tpc = new Fl_Double_Window(670, 420, gettext("Tux Paint Config v0.0.3"));
    w = o;
    o->callback((Fl_Callback*)confirm_exit_cb);
    { Fl_Tabs* o = TAB_alltabs = new Fl_Tabs(5, 30, 665, 340);
      o->box(FL_PLASTIC_UP_BOX);
      { Fl_Group* o = TABE_about = new Fl_Group(5, 64, 665, 306, gettext("About"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)132);
        o->selection_color((Fl_Color)92);
        o->align(37);
        { Fl_Group* o = GROUP_abouttpc = new Fl_Group(12, 72, 653, 288, gettext("About Tux Paint Config."));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          TEXTOUTPUT_abouttext = new Fl_Text_Display(35, 95, 610, 245);
	  TEXTOUTPUT_abouttext->buffer(TEXTBUFFER_abouttext);
	  
	  TEXTBUFFER_abouttext->text(about_text);
	  TEXTOUTPUT_abouttext->wrap_mode(1, 0);

	  //o->align(FL_ALIGN_CENTER);

          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_videoandsound = new Fl_Group(5, 64, 665, 306, gettext("Video & Sound"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)1);
        o->selection_color((Fl_Color)1);
        o->align(37);
        { Fl_Group* o = GROUP_video = new Fl_Group(12, 70, 323, 290, gettext("Video :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_fullscreen = new Fl_Check_Button(24, 96, 300, 30, gettext("&Fullscreen"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80066);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 126, 300, 36, gettext("Run Tux Paint in fullscreen mode, rather than in a window."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Group* o = GROUP_resolution = new Fl_Group(24, 193, 300, 153, gettext("Resolution / Window Size :"));
            o->box(FL_PLASTIC_UP_BOX);
            o->labeltype(FL_EMBOSSED_LABEL);
            o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
            { Fl_Round_Button* o = ROUNDBUTTON_640x480 = new Fl_Round_Button(40, 213, 272, 28, gettext("&640 x 480"));
              o->type(102);
              o->down_box(FL_ROUND_DOWN_BOX);
              o->value(1);
              o->shortcut(0x80036);
	      o->callback((Fl_Callback*)cb_status_chng);
            }
            { Fl_Round_Button* o = ROUNDBUTTON_800x600 = new Fl_Round_Button(40, 240, 272, 28, gettext("&800 x 600"));
              o->type(102);
              o->down_box(FL_ROUND_DOWN_BOX);
              o->shortcut(0x80038);
	      o->callback((Fl_Callback*)cb_status_chng);
            }
            { Fl_Box* o = new Fl_Box(40, 268, 272, 44, gettext("Size of the window / resolution in fullscreen. (Affects canvas size!)"));
              o->box(FL_BORDER_BOX);
              o->labelfont(2);
              o->labelsize(12);
              o->align(197|FL_ALIGN_INSIDE);
            }
            o->end();
          }
          o->end();
        }
        { Fl_Group* o = GROUP_sound = new Fl_Group(340, 70, 324, 290, gettext("Sound :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_soundeffects = new Fl_Check_Button(360, 96, 292, 30, gettext("Enable &Sound Effects"));
            o->down_box(FL_DOWN_BOX);
            o->value(1);
            o->shortcut(0x80073);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(360, 126, 292, 36, gettext("Enable/disable sound effects."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_mouseandkeyboard = new Fl_Group(5, 64, 665, 306, gettext("Mouse & Keyboard"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)2);
        o->selection_color((Fl_Color)2);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_mouse = new Fl_Group(12, 70, 323, 290, gettext("Mouse :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_fancycursorshapes = new Fl_Check_Button(24, 96, 300, 30, gettext("&Fancy Cursor Shapes"));
            o->down_box(FL_DOWN_BOX);
            o->value(1);
            o->shortcut(0x80066);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 126, 300, 54, gettext("Change the shape of the mouse pointer depending on where the mouse is and wha\
t you are doing.  (Disable this feature if it causes problems.)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_grabmousepointer = new Fl_Check_Button(24, 180, 300, 30, gettext("&Grab Mouse Pointer"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80067);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 210, 300, 54, gettext("Prevents the mouse pointer from leaving the Tux Paint window."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_mousewheelsupport = new Fl_Check_Button(24, 264, 300, 30, gettext("Mouse &Wheel Support"));
            o->down_box(FL_DOWN_BOX);
            o->value(1);
            o->shortcut(0x80077);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 294, 300, 54, gettext("Allows a mouse wheel to be used to scroll through items. (e.g., brushes, stam\
ps)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_keyboard = new Fl_Group(340, 70, 324, 290, gettext("Keyboard :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_enablekbd = new Fl_Check_Button(352, 96, 300, 30, gettext("Enable &Keyboard Shortcuts"));
            o->down_box(FL_DOWN_BOX);
            o->value(1);
            o->shortcut(0x8006b);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 126, 300, 54, gettext("Allows key combinations to be used as shortcuts for certain commands. (e.g., \
Control+S to Save)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_simplification = new Fl_Group(5, 64, 665, 306, gettext("Simplification"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)3);
        o->selection_color((Fl_Color)3);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_interfacesimpl = new Fl_Group(10, 70, 326, 290, gettext("Interface Simplification :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_disableshaperotation = new Fl_Check_Button(24, 96, 300, 30, gettext("Disable Shape &Rotation"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80072);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 126, 300, 54, gettext("Shape tool's rotation step is disabled. Useful for younger children."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_simpleshapeoutlines = new Fl_Check_Button(24, 180, 300, 30, gettext("Simple Stamp &Outlines"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x8006f);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 210, 300, 54, gettext("Draw a rectangle around the cursor when placing stamps, rather than a detailed outline. (For slow computers and thin clients.)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_showuppercasetextonly = new Fl_Check_Button(24, 264, 300, 30, gettext("Show &Uppercase Text Only"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80075);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 294, 300, 54, gettext("Cause all text in Tux Paint (button labels, dialogs, etc.) to appear in UPPERCASE rather than Mixed Case."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_controlsimpl = new Fl_Group(340, 70, 323, 290, gettext("Control Simplification :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_disablequitbutton = new Fl_Check_Button(352, 96, 300, 30, gettext("Disable \'&Quit\' Button"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80071);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 126, 300, 54, gettext("Clicking the window\'s close (X) button in the title bar, or pressing [Escape\
] or [Alt]+[F4] will still quit Tux Paint."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_disablestampstool = new Fl_Check_Button(352, 180, 300, 30, gettext("Disable \'&Stamps\' Tool"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80073);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 210, 300, 54, gettext("Do not load stamps at startup, thus disabling the Stamps tool."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_disablestampcontrols = new Fl_Check_Button(352, 264, 300, 30, gettext("Disable Stamp &Controls"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80063);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 294, 300, 54, gettext("Simplify the \'Stamps\' tool by removing the stamp control buttons (Shrink, G\
row, Mirror and Flip)."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_locale = new Fl_Group(5, 64, 665, 306, gettext("Languages"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)4);
        o->selection_color((Fl_Color)4);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_locale = new Fl_Group(12, 70, 653, 290, gettext("Language :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Choice* o = CHOICE_language = new Fl_Choice(20, 118, 300, 32, gettext("Language : "));
            o->down_box(FL_BORDER_BOX);
            o->align(FL_ALIGN_TOP_LEFT);
	    /* FIXME: Perhaps we can load these from Tux Paint itself using
	       a special command-line option? */
	    /* FIXME: The labels should all be wrapped in 'gettext()' calls */

	    int i;
	    for (i = 0; i < NUM_LANGS; i++)
	    {
	      o->add(langs[i][LANG_NAME], "", NULL, NULL, 0);
	    }
	    o->value(0);

	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(20, 162, 300, 54, gettext("Run Tux Paint in a particular language (overriding system's settings)."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Check_Button* o = CHECKBUTTON_mirrorstamps = new Fl_Check_Button(20, 228, 300, 32, gettext("&Mirror Stamps"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x8006d);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(20, 270, 300, 54, gettext("Automatically mirror-image all mirror-able stamps. Useful for users who prefer things appearing right-to-left."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_printing = new Fl_Group(5, 64, 665, 306, gettext("Printing"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)5);
        o->selection_color((Fl_Color)5);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_printperms = new Fl_Group(12, 70, 323, 290, gettext("Print Permissions :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_allowprinting = new Fl_Check_Button(24, 100, 300, 32, gettext("Allow &Printing"));
            o->down_box(FL_DOWN_BOX);
            o->value(1);
            o->shortcut(0x80070);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 132, 300, 40, gettext("Let users print from within Tux Paint."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Value_Input* o = VALUEINPUT_printdelay = new Fl_Value_Input(24, 195, 50, 29, gettext("Print Delay : "));
            o->maximum(3600);
            o->step(1);
            o->align(FL_ALIGN_TOP_LEFT);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = LABEL_seconds = new Fl_Box(81, 195, 244, 29, gettext("seconds"));
            o->box(FL_FLAT_BOX);
            o->align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE);
          }
          { Fl_Box* o = new Fl_Box(24, 232, 300, 40, gettext("Restrict printing to once every N seconds. (Enter '0' to allow unrestricted printing.)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_printcmd = new Fl_Group(340, 70, 323, 290, gettext("Print Command :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_usealtprintcmd = new Fl_Check_Button(350, 100, 302, 32, gettext("Use &Alternative Print Command"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80061);
            o->callback((Fl_Callback*)cb_CHECKBUTTON_usealtprintcmd);
          }
          { Fl_Box* o = new Fl_Box(352, 132, 300, 50, gettext("Override Tux Paint's built-in print command ('pngtopnm | pnmtops | lpr') with another. (Advanced! Unix/Linux only!)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Input* o = TEXTINPUT_printcmd = new Fl_Input(352, 205, 300, 29, gettext("Alternative Print Command : "));
            o->align(FL_ALIGN_TOP_LEFT);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(352, 242, 300, 50, gettext("Enter the command for printing. It must accept a PNG format graphics on its standard input (STDIN)."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = TABE_saving = new Fl_Group(5, 64, 665, 306, gettext("Saving"));
        o->box(FL_PLASTIC_UP_BOX);
        o->color((Fl_Color)6);
        o->selection_color((Fl_Color)6);
        o->align(37);
        o->hide();
        { Fl_Group* o = GROUP_saveover = new Fl_Group(12, 70, 323, 290, gettext("Save Over Earlier Work :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Round_Button* o = ROUNDBUTTON_askbeforeoverwriting = new Fl_Round_Button(24, 96, 300, 28, gettext("&Ask Before Overwriting"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->value(1);
            o->shortcut(0x80061);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 124, 300, 54, gettext("When re-saving an image, ask whether to overwrite the earlier version, or make a new file."));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Round_Button* o = ROUNDBUTTON_alwaysoverwriteolderversion = new Fl_Round_Button(24, 178, 300, 28, gettext("Always &Overwrite Older Version"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->shortcut(0x8006f);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 206, 300, 54, gettext("When re-saving an image, always overwrite the earlier version. (Warning: Potential for lost work!)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_Round_Button* o = ROUNDBUTTON_alwayssavenewpicture = new Fl_Round_Button(24, 260, 300, 28, gettext("Always Save &New Picture"));
            o->type(102);
            o->down_box(FL_ROUND_DOWN_BOX);
            o->shortcut(0x8006e);
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Box* o = new Fl_Box(24, 288, 300, 54, gettext("When re-saving an image, always make a new file. (Warning: Potential for lots of files!)"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          o->end();
        }
        { Fl_Group* o = GROUP_savedir = new Fl_Group(340, 70, 323, 290, gettext("Save Directory :"));
          o->box(FL_PLASTIC_UP_BOX);
          o->labeltype(FL_EMBOSSED_LABEL);
          o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
          { Fl_Check_Button* o = CHECKBUTTON_usealternatesavedir = new Fl_Check_Button(350, 96, 302, 28, gettext("Use &Alternative Save Directory"));
            o->down_box(FL_DOWN_BOX);
            o->shortcut(0x80061);
            o->callback((Fl_Callback*)cb_CHECKBUTTON_usealternatesavedir);
          }
          { Fl_Box* o = new Fl_Box(352, 124, 300, 54, gettext("Do not save pictures in the standard directory, use the following location:"));
            o->box(FL_BORDER_BOX);
            o->labelfont(2);
            o->labelsize(12);
            o->align(197|FL_ALIGN_INSIDE);
          }
          { Fl_File_Input* o = FILEINPUT_alternatesavedir = new Fl_File_Input(352, 220, 218, 40, gettext("Alternative Save Directory :"));
            o->align(69);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_status_chng);
          }
          { Fl_Button* o = BUTTON_browsealternatesavedir = new Fl_Button(576, 231, 77, 29, gettext("Browse..."));
            o->shortcut(0x80062);
            o->deactivate();
	    o->callback((Fl_Callback*)cb_BUTTON_browsealternatesavedir);
          }
          o->end();
        }
        o->end();
      }
      o->end();
    }
    { Fl_Button* o = BUTTON_apply = new Fl_Button(455, 388, 96, 32, gettext("Apply"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(1);
      o->align(FL_ALIGN_CLIP);
      o->callback((Fl_Callback*)cb_BUTTON_apply);
      o->deactivate();
    }
    { Fl_Button* o = BUTTON_reset = new Fl_Button(560, 388, 96, 32, gettext("Reset"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(1);
      o->callback( (Fl_Callback*)cb_BUTTON_reset );
      o->align(FL_ALIGN_CLIP);
    }
    { Fl_Button* o = BUTTON_defaults = new Fl_Button(15, 388, 96, 32, gettext("Defaults"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(1);
      o->callback((Fl_Callback*)cb_BUTTON_defaults);
      o->align(FL_ALIGN_CLIP);
    }
    { Fl_Button* o = BUTTON_quit = new Fl_Button(120, 388, 96, 32, gettext("Quit"));
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->labelfont(1);
      o->callback((Fl_Callback*)confirm_exit_cb);
      o->align(FL_ALIGN_CLIP);
    }
    o->end();
  }
  
  
  /* It's kluge to do this here; sorry -bjk 2004-09-04 */

  load_conf();


  /* Show the window: */

#ifdef WIN32
  // must set the icon before calling show()
  WINDOW_tpc->icon((char *)LoadIcon(fl_display, MAKEINTRESOURCE(IDI_ICON1)));
#endif

  WINDOW_tpc -> show ();
  return w;
}
