<?php
/**
 * This module allows you to import tasks definitions from CSV file.
 * It will certainly support more field later, but for now just allow
 * you to import your MSProject planning, for example.
 *
 * By Dimitri Fontaine <dfontaine@cvf.fr>
 *
 * $Id: task_import_csv.php,v 1.16 2003/06/27 13:56:12 gokohnert Exp $
 * $Author: gokohnert $
 *
 * @modulegroup task
 * @module task_import_csv
 * @package task
 */

 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","import");
 loadlayout();

 /**
  * import a task list
  */
 class task_import extends layout {
   /**
    * getTask
    */
   Function getTask(&$t, $name, $p_id) {
     $qt = "SELECT * FROM ".$t->tablename.
           " WHERE ".$this->dbconn->Like("name", $name)." AND p_id = '".$p_id."'";
     $rt = $this->dbconn->Exec($qt);
     if ( $rt->numrows() == 1 ) {
       $t->read_result($rt, 0);
     } else {
       $t->setName($name);
     }
     return $t;
   }
   /**
    * import
    */
   Function import() {
     global $tutos, $lang;
     global $HTTP_POST_FILES;

     $gotourl="task_import_csv.php";
     $gotourl= addUrlParameter($gotourl, "p_id=". $this->obj->id);

     if( $this->import ) {
       if( ! isset($_POST['contents']) ) {
         $msg = $lang['Err0050'];
         $gotourl = addUrlParameter($gotourl, "msg=". UrlEncode($msg));
         $this->redirect =  $gotourl;
         return;
       } else {
         $contents = $_POST['contents'];
       }
     } else {
       if( isset($HTTP_POST_FILES['userfile']) ) {
         $filename = $HTTP_POST_FILES['userfile']['tmp_name'];
         $fd = fopen($filename, "r");
         $contents = fread($fd, filesize($filename));
         fclose ($fd);
       }
     }
     // echo "<pre>Contents:". $contents ."</pre>\n";
     $lines  = explode("\n", $contents);
     $header = $lines[0];

     // Guess the separator
     $seplist = array(":", "\t", ";", ",");
     $fnames  = $header;

     for($i=0; $i < count($seplist) && count($fnames) == 1; $i++) {
       $sep = $seplist[$i];
       $fnames = explode($sep, trim($header));
     }
     if( count($fnames) < 2 ) {
       $msg = $lang['Err0051'];
       $gotourl = addUrlParameter($gotourl, "msg=". UrlEncode($msg));
       $this->redirect =  $gotourl;
       return;
     }

     // Prepare an association table
     $t_fields = array($this->fld_name    => "name",
            $this->fld_start => "s_start",
            $this->fld_end   => "s_end",
            $this->fld_volume  => "volume",
            $this->fld_index   => "index"
            );

     // Show what we read

     if( ! $this->import ) {
       // Will have to confirm the import
       echo "<form name=\"import\" action=\"task_import_csv.php\" method=\"POST\">\n";
       $this->addHidden("contents",$contents);
       $this->addHidden("p_id",$this->obj->id);
       $this->addHidden("name",$this->fld_name);
       $this->addHidden("index",$this->fld_index);
       $this->addHidden("s_start",$this->fld_start);
       $this->addHidden("s_end",$this->fld_end);
       $this->addHidden("volume",$this->fld_volume);
     }
     echo $this->DataTableStart();
     echo " <tr><th colspan=\"6\">";
     echo "Import CSV (". $lang[$this->obj->getType()] ." ". menulink($this->obj->getUrl(),$this->obj->getFullName()) .")";
     echo " </th></tr>\n";

     for($i=0; $i<count($lines); $i++) {
       $line = $lines[$i];

      if( trim($line) != "" ) {
        echo " <tr>\n";
        $fields = explode($sep, trim($line));

        $t = new task($this->dbconn);
        $t->id = -1;
        $t->creator = $this->user;
        $t->p_id = $this->obj->id;

        for($j=0; $j < count($fields); $j++) {
            if( $i == 0 ) {
            echo "<th>".$fields[$j]."</th>";
          } else {
            // Here we look what the field is
            switch( $t_fields[$fnames[$j]] ) {
               case "name": {
                 $name = $fields[$j];
                 $t->setName($name);
                 $val = $t->name;
                 break;
               }
               case "s_start": {
                 $s_start = new DateTime($this->reformat_date($fields[$j]));
                 $t->setSStart($s_start);
                 $val = $t->s_start->getYYYYMMDD();
                 break;
               }
               case "s_end": {
                 $s_end = new DateTime($this->reformat_date($fields[$j]));
                 $t->setSEnd($s_end);
                 $val = $t->s_end->getYYYYMMDD();
                 break;
               }
               case "volume": {
                 $vol = trim($fields[$j]);
                 if( ereg("([0-9]+).*(jour|day)", $vol, $regs) ) {
          // FIXME: use a localized number of worked hours (8)
                   $t->setVolume(8*(int)$regs[1]);
                 } elseif( ereg("([0-9]+).*(heure|hour)", $vol, $regs) ) {
                   $t->setVolume((int)$regs[1]);
                 } elseif( is_numeric($vol) ) {
                   $t->setVolume($vol);
                 } else {
                   $t->setVolume(0);
                 }
                 $val = $t->volume." h";
                 break;
               }
        /* Here it's a special case :
         * MS Project exports dependency field as WBS Index
         * The index is on the form: 1 1.1 1.2 2 2.1 2.1.1 2.1.2 2.2
         * So we keep some info and associate a parent task
         *
         * This is based upon the fact that the tasks in the CSV file
         * are sorted on this field.
         */
               case "index": {
                 $index = trim($fields[$j]);
                 $indexes[$index] = $t;

                 /* find the parent task with the index */
                 if( ereg("^([0-9.]*)\.[0-9]*$", $index, $regs) ) {
                   $p_task = $indexes[$regs[1]];

                   $t->p_id   = $p_task->id;
                   $t->parent = getObject($this->dbconn, $p_task->id);

                   if( $p_task->id == -1 ) {
                     $val = "$index : id(".$regs[1].")";
                   } else {
                     $val = "$index : <tt>".$p_task->id."</tt>";
                   }
                 } else {
                   $t->parent = getObject($this->dbconn, $t->p_id);
                   $val = "$index";
                 }
                 break;
               }
               default:{
                 $val = "<i>Not Used</i> [".$t_fields[$fnames[$j]]."] [".$fnames[$j].".]";
                 break;
               }
             }
             // And we print it
             echo "<td>".$val."</td>";
           }
         }
         echo " </tr>\n";
         /* Now we have registered the task fields, save the task
          * Only if the presentation page was confirmed, of course !
          */
         if( $this->import ) {
           /* There's a MS Project way of doing things we have to
            * care about.
            * Milestones are exported as tasks with s_start == s_end and
            * volume = 0.
            * We won't import such tasks
            */
           $is_ms_milestone = ( $t->s_start->getYYYYMMDD() == $t->s_end->getYYYYMMDD() ) && $t->volume == 0;

           if( $t->name != "" && ! $is_ms_milestone ) {
             $this->dbconn->Begin("WORK");
             $msg .= $t->save();
             $this->dbconn->Commit("WORK");
             // We need to get the task id
#FIXME:  should work with $t 
             $t = $this->getTask(&$t, $name, $t->p_id);

             // Let the $indexes table up-to-date
             $indexes[$index] = $t;

           }
         }
       }
     }
     if( ! $this->import ) {
       echo " <tr><td colspan=\"".count($fields)."\" align=\"center\">";
       echo "<hr><br>\n";
       echo "<input type=\"submit\" name=\"import\"";
       echo " value=\"".$lang['ImportConfirm']."\">";
       echo " </td></tr>\n";
     }
     echo $this->DataTableEnd();
     if( ! $this->import ) {
       hiddenFormElements();
       echo $this->getHidden();
       echo "</form>";
     }
   }
   /**
    * The date format I had here is the one used by french version of MSProject.
    * As I'm not sure the format DD/MM/YY is widely used, i've prefered not to
    * add it to the DateTime class.
    */
   Function reformat_date($date) {
     $datestr = explode(" ", $date);
     if( ereg("^([0-3][0-9])/([0-1][0-9])/([0-9]{2})$", $datestr[1], $regs) ) {
       // date format DD/MM/YY, transform to YYYYMMDD
       $d = "20".$regs[3].$regs[2].$regs[1];
     } else {
       $d = $datestr[1];
     }

     return $d;
   }
   /**
    * display the form
    */
   Function info() {
     global $tutos, $lang;

     if( isset($_POST['valid']) || isset($_POST['import']) ) {
       $this->import($this->obj);
       return;
     }

     echo "<form name=\"import\" enctype=\"multipart/form-data\"";
     echo " action=\"task_import_csv.php\" method=\"POST\">\n";
     $this->addHidden("p_id",$this->obj->id);
  

     echo $this->DataTableStart();
     echo " <tr><th colspan=\"4\">";
     echo "Import CSV (". $lang[$this->obj->getType()] ." ". menulink($this->obj->getUrl(),$this->obj->getFullName()) .")";
     echo " </th></tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['ImportSrcFile']);
     echo "  <td><input type=\"file\" accept=\"*.csv\" name=\"userfile\"></td>\n";
     echo " </tr>\n";

     echo " <tr><th colspan=\"2\">".$lang['ImportColNames']."</th></tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['TaskName']);
     echo "  <td><input name=\"name\" value=\"". $this->fld_name."\"></td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['ImportIndex']);
     echo "  <td><input name=\"index\" value=\"". $this->fld_index."\"></td>\n";
     echo " </tr>\n";

     /*
     echo " <tr>\n"; 
     echo "  <td class=\"desc\">".$lang['TaskState']."</td>\n";
     echo "  <td><input name=\"state\"></td>\n";
     echo " </tr>\n";
     */

     /*
     echo " <tr>\n";
     echo "  <td class=\"desc\">".$lang['TaskDesc']."</td>\n";
     echo "  <td><input name=\"desc\"></td>\n";
     echo " </tr>\n";
     */

     echo " <tr>\n";
     echo $this->showfield($lang['TaskVolumeFull']);
     echo "  <td><input name=\"volume\" value=\"". $this->fld_volume."\"></td>\n";
     echo " <tr>\n";

     /*
     echo " <tr>\n";
     echo "  <td class=\"desc\">".$lang['TaskVolumeDone']."</td>\n";
     echo "  <td><input name=\"volume_done\"></td>\n";
     echo " <tr>\n";
     */

     echo " <tr>\n";
     echo $this->showfield($lang['TaskS_Start']);
     echo "  <td><input name=\"s_start\" value=\"". $this->fld_start."\"></td>\n";
     echo " <tr>\n";

     echo " <tr>\n";
     echo $this->showfield($lang['TaskS_End']);
     echo "  <td><input name=\"s_end\" value=\"". $this->fld_end."\"></td>\n";
     echo " <tr>\n";

     if ( ($this->obj->mod_ok()) || ($this->obj->id == -1) ) {
       echo "<tr>\n";
       echo "  <td colspan=\"2\" align=\"center\">";
       echo "<input type=\"submit\" name=\"valid\" value=\"". $lang['ImportValid']."\"></td>\n";
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
   }
   /**
    * naviagtion
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $tutos,$msg,$lang;
 
     $this->name = $lang['TaskImport'];
     $this->import = false;
     $this->fld_name = "";
     $this->fld_index = "";
     $this->fld_volume = "";
     $this->fld_start = "";
     $this->fld_end = "";

     if ( isset($_POST['p_id']) ) {
       $this->obj = GetObject($this->dbconn, $_POST['p_id']);
     } else if ( isset($_GET['p_id']) ) {
       $this->obj = GetObject($this->dbconn, $_GET['p_id']);
     } else {
       $msg .= $lang['Err0048'];
       $this->stop = true;
     }
     if ( isset($_POST['name']) ) {
       $this->fld_name = $_POST['name'];
     } else if ( isset($_GET['name']) ) {
       $this->fld_name = $_GET['name'];
     }
     if ( isset($_POST['index']) ) {
       $this->fld_index = $_POST['index'];
     } else if ( isset($_GET['index']) ) {
       $this->fld_index = $_GET['index'];
     }
     if ( isset($_POST['volume']) ) {
       $this->fld_volume = $_POST['volume'];
     } else if ( isset($_GET['volume']) ) {
       $this->fld_volume = $_GET['volume'];
     }
     if ( isset($_POST['s_start']) ) {
       $this->fld_start = $_POST['s_start'];
     } else if ( isset($_GET['s_start']) ) {
       $this->fld_start = $_GET['s_start'];
     }
     if ( isset($_POST['s_end']) ) {
       $this->fld_end = $_POST['s_end'];
     } else if ( isset($_GET['s_end']) ) {
       $this->fld_end = $_GET['s_end'];
     }

     if ( isset($_POST['import']) ) {
       $this->import = true;
     }
   }
 }

 $l = new task_import($current_user);
 $l->display();
 $dbconn->Close();
?>