<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_del
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","del");

 $gotourl="task_overview.php";
 $msg = "";

 $t = new task($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= sprintf($lang['Err0040'],$lang[$t->getType()]);
 } else {
   $t->read($_GET['id']);
   $gotourl = $t->getUrl();
 }
 if ( ! $t->del_ok() ) {
   $msg .= sprintf($lang['Err0023'],$lang[$t->getType()]);
 }
 if ($msg == "") {
   $gotourl = $t->parent->getUrl();

   $dbconn->Begin("WORK");
   $msg .= $t->delete();
   $dbconn->Commit("WORK");
 }
 $gotourl = addMessage($gotourl,$msg,true);
 $gotourl = addSessionKey($gotourl,true);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: task_del.php,v 1.20 2003/12/08 17:20:38 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
