<?php
/*
 * Copyright 1999 - 2003 by Gero Kohnert
 * submitted by "Nonn" <nonn at resce.com>
 *
 * @modulegroup note
 * @module note_overview
 * @package note
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("note","overview");
 loadmodule("note");
 loadlayout();

 /**
  * a overview of notes
  */
 class note_overview extends layout {
   /**
    * display the form
    */
   Function info() {
     global $tutos,$lang;


     $n = $this->result->numrows();

     $blist = array();
     # Make a big array of all visible notes
     $x = 0;
     while ( $x < $n ) {
       $b = new note($this->dbconn);
       $b->read_result($this->result,$x);
       $x++;
       if ( ! $b->see_ok() ) {
         continue;
       }
       $blist[] = &$b;
       unset($b);
     }
     $this->result->free();
     $n = count($blist);
     if ( 0 == $n) {
       echo $this->error($lang['Err0048']);
       return;
     }

     echo $this->actionformStart("note_overview.php");
     echo $this->OverviewTableStart();
     echo "<thead>\n";
     echo "<tr>\n";
     echo $this->orderHeader("n.creation",$lang['created'],$this->link2);
     echo $this->orderHeader("",$lang['NoteName'],$this->link2);
     echo $this->orderHeader("link_id",$lang['NoteReference'],$this->link2);
     echo $this->orderHeader("remember",$lang['NoteRemember'],$this->link2);
     echo $this->orderHeader("n.creator",$lang['NoteCreator'],$this->link2);
     if ( $tutos[massupdate] == 1 ) {
       echo "  <th nowrap><input type=\"checkbox\" name=\"checkit\" onClick=\"CheckAll2();\"></th>\n";
     }
     echo "</tr>\n";
     echo "</thead>\n";

     if ( $this->start == -1 ) {
       # Show the last pasrt
       $a = $n - $tutos[maxshow];
       $end = $n;
       $this->start = $a;
     } else {
       $a = $this->start;
       $end = $this->start + $tutos[maxshow];
     }

     $this->filter['name'] = prepare_regpattern($this->filter['name']);
     echo "<tbody>\n";
     $line = 1;
     while ( ($a < $n) && ($a < $end) ) {
       $b = &$blist[$a];
       $b->read_reference();

       echo $this->OverviewRowStart($line);
       echo " <td>". $b->creation->getDateTime() ."</td>\n";
       $x = myentities($b->getFullName());
       if ( $this->filter['name'] != "" ) {
         $x = eregi_replace("(". $this->filter['name'] .")","<span class=\"found\">\\1</span>",$x);
       }
       echo " <td>". makelink($b->getUrl(),$x) ."</td>\n";
       echo " <td>&nbsp;". $b->ref->getLink() ."</td>\n";
       echo " <td>&nbsp;". $b->remember->getDateTime() ."</td>\n";
       echo " <td>&nbsp;". $b->creator->getLink($b->creator->getShortname()) ."</td>\n";
       if ( $tutos[massupdate] == 1 ) {
         echo " <td align=\"center\">\n";
         if ( $b->mod_ok() ) {
           echo "<input name=\"mark[]\" type=\"checkbox\" value=\"". $b->id ."\">\n";
         } else {
           echo "-\n";
         }
         echo "</td>\n";
       }
       echo $this->OverviewRowEnd($line++);
       unset($b);
       $a++;
     }
     echo "</tbody>\n";

     echo $this->list_navigation($this->link1,5+$tutos[massupdate],$this->start,$a,$n);
     if ( $tutos[massupdate] == 1 ) {
       echo $this->UpdateRowStart(4);
       echo sprintf($lang['withmarked'],$lang['Notes']);
       echo "<select name=\"action\">\n";
       echo " <option value=\"-1\" selected>". $lang['ActionNil'] ."</option>\n";
       echo " <option value=\"-2\">". $lang['Delete'] ."</option>\n";
       echo " <option value=\"-4\">". $lang['AclModify'] ."</option>\n";
       if (class_exists('watchlist')) {
         echo " <option value=\"WatchAdd\">". $lang['WatchAdd'] ."</option>\n";
         echo " <option value=\"WatchDel\">". $lang['WatchDel'] ."</option>\n";
       }
       echo "</select>\n";
       echo $this->UpdateRowEnd(2);
     }
     echo $this->OverviewTableEnd();
     echo $this->actionformEnd("note_overview.php");
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * action via massupdate
    */
   Function action() {
     global $lang,$msg;

     if ( $_GET['action'] == -2 ) {
       $this->dbconn->Begin("WORK");
       foreach ($_GET['mark'] as $key => $val) {
         $b = new note($this->dbconn);
         $b->read($val);
         if ( $b->id != $val ) {
           continue;
         }
         if ( $b->del_ok() ) {
           $msg .= $lang['Delete'].":". $b->getFullName() ."<br>";
           $msg .= $b->delete();
         } else {
           $msg .= $b->getLink() .": ". sprintf($lang['Err0023'],$lang[$b->getType()]) ."<br>\n";
         }
         unset($b);
       }
       $this->dbconn->Commit("WORK");
       return;
     }
     if ( $_GET['action'] == -4 ) {
       $this->redirect = "../". acl_action();
       return;
     }
     if (class_exists('watchlist')) {
       watchlist::parse_action($this->user);
     }
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['NotesOverview'];

     if ( ! $this->user->feature_ok(usenotes,PERM_SEE) ) {
       $msg .= sprintf($lang['Err0022'],"'". $this->name ."'");
       $this->stop = true;
     }

     $this->link1 = "note/note_overview.php";
     $this->filter = array();

     $reftype = "";
     $name = "";
     $nsrn = "";
     $nscr = "";

     if ( isset($_GET['reftype']) ) {
       $reftype = $_GET['reftype'];
     }
     if ( isset($_GET['name']) ) {
       $name = $_GET['name'];
     }
     if ( isset($_GET['nsrn']) ) {
       $nsrn = $_GET['nsrn'];
     }
     if ( isset($_GET['nscr']) ) {
       $nscr = $_GET['nscr'];
     }


     $j = "SELECT DISTINCT n.* FROM ". $this->dbconn->prefix ."notes n ";   // select + join
     $q = "";
     $pre = " WHERE ";

     if ( ($name != "*") && ($name != "") ) {
       $q .= " " . $pre ."(". $this->dbconn->Like("n.note",$name) ." OR ". $this->dbconn->Like("n.name",$name) .")";
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"name=".UrlEncode($name));
       $this->filter['name'] = $name;
     } else {
       $this->filter['name'] = "";
     }

     if ( isset($_GET['id'])  ) {
       if (false == is_numeric($_GET['id'])) {
         $msg .= sprintf($lang['Err0012'],"id",$_GET['id']);
         $this->stop = true;
       }
       $q .= " ". $pre ." n.id = ".$_GET['id'];
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"id=". $_GET['id']);
     }

     if ( isset($_GET['link_id']) ) {
       if (false == is_numeric($_GET['link_id'])) {
         $msg .= sprintf($lang['Err0012'],"link_id",$_GET['link_id']);
         $this->stop = true;
       }
       $q .= " ". $pre ." n.link_id = ".$_GET['link_id'];
       $pre = " AND ";
       $this->link1 = addUrlParameter($this->link1,"link_id=". $_GET['link_id']);
     }

     # References to display
     if ( ($reftype > 0) || ($reftype > 0 && ($nsrn != "*") && ($nsrn != "")) )  {
       if ( ! isset($nsrn) || ($nsrn == "*") ) {
         $nsrn = "";
       }
       if ( ($reftype == 1) || ($reftype == -1) ) {
         $j .= ", ". $this->dbconn->prefix ."companies c ";
         $q .= " ". $pre . "(n.link_id=c.id ";
         if ( $nsrn != "" ) {
           $q .= " AND ". $this->dbconn->Like("c.name",$nsrn);
         }
         $q .= ")";
         $pre = " OR ";
       }
       if ( ($reftype == 2) || ($reftype == -1) ) {
         $j .= ",". $this->dbconn->prefix ."departments d ";
         $q .= " ". $pre . "(n.link_id=d.id ";
         if ( $nsrn != "" ) {
           $q .= " AND ". $this->dbconn->Like("d.name",$nsrn);
         }
         $q .= ")";
         $pre = " OR ";
       }
       if ( ($reftype == 3) || ($reftype == -1) ) {
         $j .= ",". $this->dbconn->prefix ."addresses a ";
         $q .= $pre ."( (";
         $q .= $this->dbconn->Like("a.f_name",$nsrn) ." OR ";
         $q .= $this->dbconn->Like("a.m_name",$nsrn) ." OR ";
         $q .= $this->dbconn->Like("a.l_name",$nsrn) .")";
         $q .= " AND n.link_id=a.id )";
         $pre = " OR ";
       }
       if ( ($reftype == 4) || ($reftype == -1) ) {
         $j .= ",". $this->dbconn->prefix ."bugs b";
         $q .= " ". $pre . "(n.link_id=b.id ";
         if ( $nsrn != "" ) {
           $q .= " AND ". $this->dbconn->Like("b.short",$nsrn);
         }
         $q .= ")";
         $pre = " OR ";
       }
       if ( ($reftype == 5) || ($reftype == -1) ) {
         $j .= ",". $this->dbconn->prefix ."products p";
         $q .= $pre ."( n.link_id=p.id ";
         if ( $nsrn != "" ) {
           $q .= " AND (";
           $q .= $this->dbconn->Like("p.name",$nsrn) ." OR ";
           $q .= $this->dbconn->Like("p.version",$nsrn) .")";
         }
         $q .= ")";
         $pre = " OR ";
       }
       if ( ($reftype == 6) || ($reftype == -1) ) {
         $j .= ",". $this->dbconn->prefix ."teams t";
         $q .= $pre . "(n.link_id=t.id AND ". $this->dbconn->Like("t.name",$nsrn) .")";
         $pre = " OR ";
       }
       if ( ($reftype == 7) || ($reftype == -1) ) {
         $j .= ",". $this->dbconn->prefix ."tasks k";
         $q .= $pre . "(n.link_id=k.id AND ". $this->dbconn->Like("k.name",$nsrn) .")";
         $pre = " OR ";
       }
       if ( ($reftype == 8) || ($reftype == -1) ) {
         $j .= ",". $this->dbconn->prefix ."installations i";
         if ( ! stristr($j, "products") ) {
           $j .= ",". $this->dbconn->prefix ."products p";
         }
         $q .= $pre ."( n.link_id=i.id AND i.product_id=p.id AND (";
         $q .= $this->dbconn->Like("p.name",$nsrn) ." OR ";
         $q .= $this->dbconn->Like("p.version",$nsrn) .") )";
         $pre = " OR ";
       }
       $pre = "AND ";

       $this->link1 = addUrlParameter($this->link1,"reftype=". $reftype);
       $this->link1 = addUrlParameter($this->link1,"nsrn=". $nsrn);
       # remember this
       $_SESSION['notesearchreftype'] = $reftype;
       $this->filter['reftype'] = $reftype;
     }
     if ( ($nscr != "*") && ($nscr != "") ) {
       $j .= ", addresses ";
       $q .= $pre ."( (";
       $q .= $this->dbconn->Like("addresses.f_name",$nscr) ." OR ";
       $q .= $this->dbconn->Like("addresses.m_name",$nscr) ." OR ";
       $q .= $this->dbconn->Like("addresses.l_name",$nscr) .")";
       $q .= " AND n.creator=addresses.id )";
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"nscr=".UrlEncode($nscr));
       $this->filter['nscr'] = $nscr;
     }

     # Start Date for search
     $from = new DateTime(0);
     if ( isset($_GET['fd']) ) {
       $from->setDateTime($_GET['fd']);
     } else {
       $from->setDateTimeF("f");
       # remember this
#       session_register('notesearchfrom');
       $_SESSION['notesearchfrom'] = $from->getYYYYMMDD();
     }
     if ( $from->notime != 1 ) {
       $q .= $pre ."(n.creation >= ". $this->dbconn->Date($from) .")";
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"fd=".$from->getYYYYMMDD());
       $this->filter['from'] = $from;
     }
     # End Date for search
     $to = new DateTime(0);
     if ( isset($_GET['td']) ) {
       $to->setDateTime($_GET['td']);
     } else {
       $to->setDateTimeF("t");
       # remember this
#       session_register('notesearchto');
       $_SESSION['notesearchto'] = $to->getYYYYMMDD();
     }
     if ( $to->notime != 1 ) {
       $q .= $pre ."(n.creation <= ". $this->dbconn->Date($to) .")";
       $pre = "AND ";
       $this->link1 = addUrlParameter($this->link1,"td=".$to->getYYYYMMDD());
       $this->filter['to'] = $to;
     }

     $this->q = $j.$q;
     check_dbacl( $this->q, $this->user->id);

     # sorting
     $xxx = "";
     $this->link2 = $this->link1;
     order_parse($this->q,$this->link1,$xxx,$xxx,"n.creation DESC");

     if ($this->stop) {
       return;
     }
     $this->result = $this->dbconn->Exec($this->q);
     if ( 0 == $this->result->numrows()) {
       $this->redirect = "note_select.php?msg=". UrlEncode($lang['Err0048']);
       $this->result->free();
     }

     # menu
     $x = note::getSelectLink($this->user,$lang['Search']);
     $x[category][] = "obj";
     $this->addMenu($x);
     web_StackStartLayout($this,"note/note_overview.php","note/note_overview.php?".$_SERVER['QUERY_STRING']);
   }
 }


 $l = new note_overview($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: note_overview.php,v 1.34 2004/01/16 19:29:41 gokohnert Exp $
    $Author: gokohnert $
-->
