<?php
/**
 * Copyright 1999 - 2004 by Gero Kohnert
 *
 * Create a new mail
 *
 * CVS Info:  $Id: mail_new.php,v 1.31.2.1 2004/04/14 17:39:10 tapoueh Exp $
 * $Author: tapoueh $
 *
 * @modulegroup mail
 * @module mail_new
 * @package mail
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("mail","new");
 loadlayout();

 /**
  * write a new mail
  */
 class mail_new extends layout {
   /**
    * display the info
    */
   Function info() {
     global $tutos,$lang;

     echo "<form name=\"mailnew\" enctype=\"multipart/form-data\" action=\"mail_ins.php\" method=\"post\">\n";
     $this->addHidden("gotourl","mail_new.php");
     echo $this->DataTableStart();

     echo "<tr>\n";
     echo " <th colspan=\"4\">". $lang['MailboxEmail'] ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailFrom'],0,"from");
     echo " <td colspan=\"3\">\n";
     $d = $this->obj->from->default_email();
     echo "  <select name=\"from\">\n";
     if ( isset($this->obj->from->location) ) {
       @reset($this->obj->from->location);
       while( list ($i,$f) = @each ($this->obj->from->location)) {
         if ( $f->email_1 != "") {
           echo "   <option value=\"1,". $f->id ."\"". ($d == $f->email_1 ? " selected" : "") .">". $f->email_1 ."</option>\n";
         }
         if ( $f->email_2 != "") {
           echo "   <option value=\"2,". $f->id ."\"". ($d == $f->email_2 ? " selected" : "") .">". $f->email_2 ."</option>\n";
         }
       }
     }
     echo "  </select>\n";
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailTo'],1,"to");
     echo " <td colspan=\"3\">\n";
     echo "  <input size=\"40\" maxlength=\"200\" name=\"to\" value=\"". myentities($this->obj->getToAscii()) ."\">\n";
     echo " </td>\n";
     echo "</tr>\n"; 

     echo "<tr>\n";
     echo $this->showfieldc($lang['MailCc'],0,"cc");
     echo " <td colspan=\"3\">\n";
     echo "  <input id=\"cc\" size=\"40\" maxlength=\"200\" name=\"cc\" value=\"". myentities($this->obj->getCcAscii()) ."\">\n";
     echo " </td>\n";
     echo "</tr>\n";
     
     echo "<tr>\n";
     echo $this->showfieldc($lang['MailBcc'],1,"bcc");
     $xx = $this->obj->getBccAscii();
     if ( strlen($xx) < 200 ) {
       echo " <td colspan=\"3\">\n";
       echo "  <input size=\"40\" maxlength=\"3000\" name=\"bcc\" value=\"".  myentities($xx) ."\">\n";
       echo " </td>\n";
     } else {
       echo $this->showdata($lang[$this->to->getType()] ." ". $this->to->getLink(),3);
       $this->addHidden("toid",$_GET['toid']);
     }
     echo "</tr>\n";     
 
     echo "<tr>\n";
     echo $this->showfieldc($lang['MailSubject'],0,"subject");
     echo " <td colspan=\"3\">\n";
     echo "  <input id=\"subject\" size=\"40\" maxlength=\"60\" name=\"subject\" value=\"".  myentities($this->obj->subject) ."\">\n";
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td colspan=\"4\">\n";
     echo "  <textarea id=\"body\" wrap=\"hard\" rows=\"40\" cols=\"80\" name=\"body\">". $this->obj->newbody ."</textarea>\n";
     echo " </td>\n";
     echo "</tr>\n";

     if ($this->noattach == false) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['MailAttachmentNew'],0,"file");
       echo " <td colspan=\"3\">\n";
       echo " <input size=\"30\" id=\"file\" name=\"file\" type=\"file\" value=\"". myentities($this->filepath) ."\">\n";
       echo " </td>\n";
       echo "</tr>\n";
     }
     submit_reset(0,1,1,1,1,0);
     echo $this->DataTableEnd();
     echo $this->getHidden();
     hiddenFormElements();
     echo "</form>\n";
     echo $this->setfocus("mailnew.body");
#     echo $this->obj->info($this,$this->format,0);
   }
   /**
    *
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['MailboxEmail'];

     $this->obj = new mail($this->user);

     $this->filepath = "";

     # reply type
     # 0 = new message
     # 1 = reply
     # 2 = reply all
     # 3 = forward
     if ( isset($_GET['reply']) ) {
       $this->reply = $_GET['reply'];
       $this->addHidden("reply",$_GET['reply']);
     } else {
       $this->reply = 0;
     }

     if ( isset($_GET['mid']) ) {
       // a reference to an phpimap type mail
       $this->addHidden("mid",$_GET['mid']);
       loadmodule('mailbox');
       $this->mbox = new mailbox($this->dbconn);
       $this->mbox->read($_GET['mid']);
       if ( isset($_GET['mpath']) ) {
         $this->addHidden("mpath",$_GET['mpath']);
         $this->mbox->setPath(Base64_Decode($_GET['mpath']));
       }
       $this->mbox->open();
       $this->mno = $_GET['mno'];
       $this->addHidden("mno",$_GET['mno']);
       $this->obj->init_by_phpimap($this->mbox,$this->mno,false);
       $this->mbox->close();

       $url = $this->mbox->getUrl();
       if ( $this->mbox->addpath != "" ) {
         $url= addUrlParameter($url,"path=".Base64_Encode($this->mbox->addpath));
       }
       $x = array( url => $url,
                   text => $lang['MailboxOverview'],
                   info => $lang['MailboxOverview'],
                   confirm => false,
                   category => array("mailbox","show","obj")
                 );
       $this->addMenu($x);

     } else if ( isset($_GET['fid']) ) {
       // a reference to an docmanagement type mail
       loadmodule('file');
       $this->addHidden("fid",$_GET['fid']);
       $this->file = new tutos_file($this->dbconn);
       $this->file->read($_GET['fid']);
       $this->obj->init_by_file_obj($this->file,false);
     } else {
       // clean start with an empty mail
       $this->obj->newbody = "";
     }


     if ( $this->reply == 1 ){
       $this->obj->to_adr = array();
       $this->obj->to_adr[] = decodeHeader($this->obj->from_adr);
       $this->obj->setSubject("Re:". decodeHeader($this->obj->getSubject()));

       $this->obj->newbody = sprintf($lang['MailQuoteHead'],$this->obj->date,decodeHeader($this->obj->from_adr)) ."\n";
       // get the first text/plain body
       $nbody  = $this->obj->show_html($this,"reply",0);
       foreach (split("[\n]",$nbody) as $line) {
         $this->obj->newbody .= "> ". $line;
       }
       $this->obj->newbody .= "\n\n";
     } else if ( $this->reply == 2 ){
       $this->obj->cc_adr = array();
       foreach($this->obj->to_adr as $i) {
         $this->obj->cc_adr[] = decodeHeader($i);
       }
       $this->obj->to_adr = array();
       $this->obj->to_adr[] = decodeHeader($this->obj->from_adr);
       $this->obj->setSubject("Re:". $this->obj->getSubject());

       // get the first text/plain body
       $this->obj->newbody = sprintf($lang['MailQuoteHead'],$this->obj->date,decodeHeader($this->obj->from_adr)) ."\n";
       // get the first text/plain body
       $nbody  = $this->obj->show_html($this,"reply",0);
       foreach (split("[\n]",$nbody) as $line) {
         $this->obj->newbody .= "> ". $line;
       }
       $this->obj->newbody .= "\n\n";
     } else if ( $this->reply == 3 ){
       $this->obj->setSubject("Fw:". $this->obj->getSubject());
       $this->obj->newbody = "--- original message ---\n";
       $this->obj->newbody .= $this->obj->shortinfo("plain");
       // get the first text/plain body
       $this->obj->newbody .= $this->obj->show_html($this,"reply",0);
       $this->obj->newbody .= "\n\n";
     } else {
       if ( isset($_GET['subject']) ) {
         $this->obj->setSubject(StripSlashes($_GET['subject']));
       }
     }

     $this->obj->setFrom($this->user);


     if ( isset($_GET['filepath']) ) {
       $this->obj->file_path = $_GET['filepath'];
     }
     if ( isset($_GET['to']) ) {
       foreach ( $_GET['to'] as $t ) {
         $this->obj->addTo(StripSlashes($t));
       }
     } 
     if ( isset($_GET['noattach']) ) {
       $this->noattach = true;
     } else {
       $this->noattach = false;
     }

     if ( isset($_GET['toid']) ) {
       $this->to = getObject($this->dbconn,$_GET['toid']);
       if ( $this->to->getType() == "team" ) {
          // team members are sent in bcc
         $this->obj->addBcc($this->to);
         $this->obj->addTo($this->user);
       } else if ( $this->to->getType() == "product" ) {
         $this->to->readroles();
         foreach ($this->to->role as $role => $f) {
           if ( isset ($this->to->role[$role] ) && is_array ($this->to->role[$role]) ) {
             foreach($this->to->role[$role] as $i => $o) {
               $this->obj->addTo($o);
             }
           }
         }
       } else if ( $this->to->getType() == "group" ) {
         $this->to->read_member();
         foreach( $this->to->member as $i => $o) {
           $this->obj->addTo($o);
         }
       } else {
         $msg .= "Unknown toid". $this->to->id ." ". $_GET['toid'] ." ". $this->to->getType();
         $this->stop = true;
       }
       $this->name .= ":". $this->to->getFullName();
     }
     # Mail to a watchlist
     if ( isset($_GET['watch']) ) {
       loadmodule('watchlist');
       $this->to = getObject($this->dbconn,$_GET['watch']);
       watchlist::obj_read($this->to);
       foreach($this->to->list[usewatchlist] as $i => $t) {
         $this->obj->addBCc($t);
       }
       $this->name .= ":". $this->to->getFullName();
     }
     if ( isset($_GET['cc']) ) {
       foreach ( $_GET['cc'] as $t ) {
         $this->obj->addCc($t);
       }
     }
     if ( isset($_GET['bcc']) ) {
       foreach ( $_GET['bcc'] as $t ) {
         $this->obj->addBcc($t);
       }
     }     
     if ( isset($_GET['body']) ) {
       $this->obj->newbody = Base64_Decode($_GET['body']);
     }
     if ( isset($_GET['bodyid']) ) {
       $this->obj->newbody = Base64_Decode($_SESSION['BODY'.$_GET['bodyid']]);
       unset($_SESSION['BODY'.$_GET['bodyid']]);
     }
   }
 }

 $l = new mail_new($current_user);
 $l->display();
 $dbconn->Close();
?>