//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include <cassert>

#include <tulip/BooleanProperty.h>
#include <tulip/AcyclicTest.h>

#include "SpanningDagSelection.h"

BOOLEANPLUGIN(SpanningDagSelection,"Spanning Dag","David Auber","01/12/1999","Alpha","1.0");

using namespace std;
using namespace tlp;

//=================================================================
SpanningDagSelection::SpanningDagSelection(const PropertyContext &context):BooleanAlgorithm(context) {}
//=================================================================
bool SpanningDagSelection::run() {
  booleanResult->setAllNodeValue(true);
  booleanResult->setAllEdgeValue(true);
  vector<edge> obstructions;
  AcyclicTest::acyclicTest(graph, &obstructions);
  for (vector<edge>::const_iterator it = obstructions.begin(); it != obstructions.end(); ++it) {
    booleanResult->setEdgeValue(*it, false);
  }
  return true;
}
//=================================================================
