//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef PROPERTYDIALOG_H
#define PROPERTYDIALOG_H
#include <string>

#include <tulip/Graph.h>
#include <tulip/Observable.h>

#include "PropertyDialogData.h"

class Q3ListViewItem;
class QStringList;
class QScrollBar;

namespace tlp {
class PropertyInterface;
class GlGraph;
}

class PropertyDialog : public PropertyDialogData
{ 
  Q_OBJECT;

public:
  PropertyDialog(QWidget *parent = 0, const char *name = 0, bool modal = FALSE, WFlags fl = 0);
  ~PropertyDialog();
  void setGlGraphWidget(tlp::GlGraph *);

private:
  tlp::Graph *supergraph;
  tlp::GlGraph *glWidget;
  tlp::PropertyInterface *editedProperty;
  std::string editedPropertyName;
  bool _filterSelection;
  void updateNbElements();
  
public slots:  
  ///Manages observers change notification.
  void update();
  void selectNode(tlp::node);
  void selectEdge(tlp::edge);
  void setGraph(tlp::Graph *);
  void changePropertyName(Q3ListViewItem *);
  void newProperty();
  void removeProperty();
  void cloneProperty();
  void toStringProperty();
  void filterSelection(bool);
  void setAllValue();
  
signals:
  void tulipAllNodePropertyChanged(tlp::Graph *, const QString &property, const QString &value);
  void tulipAllEdgePropertyChanged(tlp::Graph *, const QString &property, const QString &value);
};

#endif // PROPERTYDIALOG_H
