//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef TREETOOLS_H
#define TREETOOLS_H

#include <tulip/Node.h>
#include <tulip/Graph.h>
#include <tulip/LayoutProperty.h>
#include <tulip/SizeProperty.h>

//====================================================================
inline bool isLeaf (const tlp::Graph* tree, tlp::node n) {
    return tree->outdeg(n) == 0;
}

//====================================================================
inline float getNodeX(tlp::LayoutProperty* pLayout, tlp::node current) {
    return pLayout->getNodeValue(current).getX();
}

//====================================================================
inline float getNodeY(tlp::LayoutProperty* pLayout, tlp::node current) {
    return pLayout->getNodeValue(current).getY();
}

//====================================================================
inline float getNodeHeight(tlp::SizeProperty* size, tlp::node current) {
    return size->getNodeValue(current).getH();
}

//====================================================================
inline float getNodeWidth(tlp::SizeProperty* size, tlp::node current) {
    return size->getNodeValue(current).getW();
}
#endif

