//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef _METAGRAPHALGO_H
#define _METAGRAPHALGO_H

#include "PropertyAlgorithm.h"

namespace tlp {

class PropertyContext;
class GraphProperty;

/** \addtogroup plugins */ 
/*@{*/

/// Interface for graph plug-ins
class GraphAlgorithm:public PropertyAlgorithm { 
  ///
  friend class GraphProperty;
public:
  /** This graph property is the one associated to the algorithm,
    *  The data should be store in it
    */
  GraphProperty *graphResult;
protected:
  ///
  GraphAlgorithm (const PropertyContext & context);
  ///
  virtual ~GraphAlgorithm(){}
};
/*@}*/

}
#endif

