//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
//*********************************************************************************
//** GlADQuad.cpp : Source for a general quad display class
//** 
//** author : Delorme Maxime
//** date   : 07/07/05
//*********************************************************************************
#include "tulip/GlADQuad.h"

using namespace std;
using namespace tlp;

GlADQuad::GlADQuad()
{
  // No default constructor :)
}

void GlADQuad::setPosition(const Coord& position)
{
  // No setPosition
}

void GlADQuad::setColor(const Color& color)
{
  // No setColor
}

GlADQuad::GlADQuad(Coord positions[N_QUAD_POINTS], const Color &color)
{
  renderOptions.setRenderState(GlAD_Wireframe, false);
  renderOptions.setRenderState(GlAD_Solid, true);

  for(int i=0; i < N_QUAD_POINTS; i++)
    {
      this->positions[i] = new Coord(positions[i]);
      this->colors[i]    = new Color(color);
    }
}

GlADQuad::GlADQuad(Coord positions[N_QUAD_POINTS], Color colors[N_QUAD_POINTS])
{
  renderOptions.setRenderState(GlAD_Wireframe, false);
  renderOptions.setRenderState(GlAD_Solid, true);

  for(int i=0; i < N_QUAD_POINTS; i++)
    {
      this->positions[i] = new Coord(positions[i]);
      this->colors[i]    = new Color(colors[i]);
    }    
}

GlADQuad::~GlADQuad()
{
  for(int i=0; i < N_QUAD_POINTS; i++)
    {
      delete positions[i];
      delete colors[i];
    }
}

void GlADQuad::setPosition(int idPosition, const Coord &position)
{
  if (idPosition < 0 || idPosition >= N_QUAD_POINTS)
    return;

  delete this->positions[idPosition];

  this->positions[idPosition] = new Coord(position);
}

void GlADQuad::setColor(int idColor, const Color &color)
{
  if (idColor < 0 || idColor >= N_QUAD_POINTS)
    return;

  delete this->colors[idColor];

  this->colors[idColor] = new Color(color);
}

Coord* GlADQuad::getPosition(int idPosition) const
{
  if (idPosition < 0 || idPosition >= N_QUAD_POINTS)
    return NULL;

  return positions[idPosition];
}

Color* GlADQuad::getColor(int idColor) const
{
  if (idColor < 0 || idColor >= N_QUAD_POINTS)
    return NULL;

  return colors[idColor];
}

void GlADQuad::draw(GlGraph* graph)
{
  setup();

  GLfloat* cols[N_QUAD_POINTS];

  for(int i=0; i < N_QUAD_POINTS; i++)
    cols[i] = colors[i]->getGL();

  bool Solid = renderOptions.getRenderState(GlAD_Solid);

  if (Solid)
    {
      glBegin(GL_QUADS);
	  
      for(int i=0; i < N_QUAD_POINTS; i++)
	{
	  glColor4fv(cols[i]);
	  glVertex3f(positions[i]->getX(), positions[i]->getY(), positions[i]->getZ());
	}
	
      glEnd();
    }
    
  if (renderOptions.getRenderState(GlAD_Wireframe))
    {
	
      if (Solid)
	{
	  GLfloat colBk[4] = {0.0f, 0.0f, 0.0f, 255.0f};

	  for (int i=0; i < N_QUAD_POINTS; i++)
	    cols[i] = colBk;
	}

      glBegin(GL_LINE_STRIP);
	   
      for(int i=0; i <= N_QUAD_POINTS; i++)
	{
	  int id = i % N_QUAD_POINTS;
	    
	  glColor4fv(cols[id]);
	  glVertex3f(positions[id]->getX(), positions[id]->getY(), positions[id]->getZ());
	}
	
      glEnd();
    }

  unsetup();
}
