//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
//*********************************************************************************
//** GlADPoint.cpp : Source for an augmented display line
//** 
//** author : Delorme Maxime
//** date   : 07/07/05
//** author : Auber David
//** date   : 01/10/06
//*********************************************************************************

#include "tulip/GlADLine.h"

using namespace std;

namespace tlp {

  //===================================================
  GlADLine::GlADLine(const Coord& startPosition, 
		     const Coord& endPosition, 
		     const Color& startColor, 
		     const Color& endColor, 
		     const unsigned int thickness) :
    startPosition(startPosition), endPosition(endPosition),
    startColor(startColor), endColor(endColor),
    thickness(thickness) {
  }
  //===================================================
  GlADLine::~GlADLine(){}
  //===================================================
  void GlADLine::draw(GlGraph* graph) {
    setup();
    glLineWidth(thickness);
    glBegin(GL_LINES);
    glColor4ubv((unsigned char *) &startColor);  
    glVertex3fv((float *) &startPosition);
    glColor4ubv((unsigned char *) &endColor);
    glVertex3fv((float *) &endPosition);  
    glEnd(); 
    unsetup();
  }
  //===================================================
  Coord GlADLine::getStartPosition() const {
    return startPosition;
  }
  //===================================================
  Coord GlADLine::getEndPosition() const {
    return endPosition;
  }
  //===================================================
  Color GlADLine::getStartColor() const {
    return startColor;
  }
  //===================================================
  Color GlADLine::getEndColor() const {
    return endColor;
  }
  //===================================================
  unsigned int GlADLine::getThickness() const {
    return thickness;
  }
  //===================================================
  void GlADLine::setStartPosition(const Coord& startPosition) {
    this->startPosition = startPosition;
  }
  //===================================================
  void GlADLine::setEndPosition(const Coord& endPosition) {
    this->endPosition = endPosition;
  }
  //===================================================
  void GlADLine::setStartColor(const Color& startColor) {
    this->startColor = startColor;
  }
  //===================================================
  void GlADLine::setEndColor(const Color& endColor) {
    this->endColor = endColor;
  }
  //===================================================
  void GlADLine::setThickness(int thickness) {
    this->thickness = thickness;
  }
  //===================================================
}
