//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef TOOLBAR_H
#define TOOLBAR_H
#include "ToolBarData.h"

class MouseInterface;

class ToolBar : public ToolBarData
{ 
  Q_OBJECT;

public:
  ToolBar( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~ToolBar();
  
  MouseInterface *getCurrentMouse() const;

protected:
  void setCurrentMouse(MouseInterface *);
  
public slots:
  void setSelect();
  void setAddEdge();
  void setAddNode();
  void setDel();
  void setZoomBox();
  void setMoveSelection();
  void setSelection();
  void setMagicSelection();
  void setGraphNavigate();

signals:
  void mouseChanged(MouseInterface *);
  
private:
  MouseInterface *currentMouse;
};

#endif // TOOLBAR_H
