//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 01/05/2002
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif
#include <iostream>

#include <tulip/TulipPlugin.h>
#include <tulip/Coord.h>
#include <tulip/PropertyProxy.h>

using namespace std;


static string convert(string tmp) {
  string newStr;
  for (unsigned int i=0;i<tmp.length();i++) {
    if (tmp[i]=='\"')
      newStr+="\\\"";
    else
      if (tmp[i]=='\n')
	newStr+="\\n";
      else
	newStr+=tmp[i];
  }
  return newStr;
}

/** \addtogroup export */
/*@{*/
struct TLP:public ExportModule {

  DataSet displaying;
  
  TLP(ClusterContext context):ExportModule(context) {
    addParameter<DataSet>("displaying");
  }
    //=====================================================
  ~TLP(){}
    //=====================================================
  void saveGraphElements(ostream &os,SuperGraph *graph) {
    if (graph->getFather() != graph) {
      os << "(cluster " << graph->getId() << " \"" << graph->getAttribute<string>("name") << "\"" << endl;
      Iterator<node> *itN = graph->getNodes();
      if (itN->hasNext()) {
	os << "(nodes ";
	while (itN->hasNext()) {
	  os << itN->next().id;
	  if (itN->hasNext()) os << " ";
	}
	os << ")" << endl;
      } delete itN;
      Iterator<edge> *itE = graph->getEdges();
      if (itE->hasNext()) {
	os << "(edges ";
	while (itE->hasNext()) {
	  os << itE->next().id;
	  if (itE->hasNext()) os << " ";
	}
	os << ")" << endl;
      } delete itE;
    }
    else
      os << graph << endl;
    Iterator<SuperGraph *> *itS = graph->getSubGraphs();
    while (itS->hasNext())
      saveGraphElements(os,itS->next());
    delete itS;
    if (graph->getFather() != graph)  os << ")" << endl;
  }
  //=====================================================
  void saveLocalProperties(ostream &os,SuperGraph *graph) {
    Iterator<string> *itS=graph->getLocalProperties();
    PProxy *pproxy;
    while (itS->hasNext()) {
      string its=itS->next();
      pproxy=graph->getProperty(its);
      if (graph->getFather()==graph)
	os << "(property " << " 0 " << pproxy->getTypename() << " " ;
      else
	os << "(property " << " " << graph->getId() << " " << pproxy->getTypename() << " " ;
      os << "\"" << convert(its) << "\"" << endl;
      string nDefault = pproxy->getNodeDefaultStringValue();
      string eDefault = pproxy->getEdgeDefaultStringValue();
      os <<"(default \"" << convert(nDefault) << "\" \"" << convert(eDefault) << "\" )" << endl; 
      Iterator<node> *itN=graph->getNodes();
      while (itN->hasNext()) {
	node itn=itN->next();
	string tmp = pproxy->getNodeStringValue(itn);
	if (strcmp(tmp.c_str(),nDefault.c_str())!=0) os << "(node " << itn.id << " \"" << convert(tmp) << "\")" << endl ;
      } delete itN;
      Iterator<edge> *itE=graph->getEdges();
      while (itE->hasNext()) {
	edge ite=itE->next();
	string tmp = pproxy->getEdgeStringValue(ite);
	if (strcmp(tmp.c_str(),eDefault.c_str())!=0) os << "(edge " << ite.id << " \"" << convert(tmp) << "\")" << endl ;
      } delete itE;
      os << ")" << endl;
    }
    delete itS;
  }
  //=====================================================
  void saveProperties(ostream &os,SuperGraph *graph) {
    saveLocalProperties(os,graph);
    Iterator<SuperGraph *> *itS=graph->getSubGraphs();
    while (itS->hasNext())
      saveProperties(os,itS->next());
    delete itS;
  }
  //=====================================================
  void saveAttributes(ostream &os, SuperGraph *graph) {
    DataSet &dataSet = graph->getAttributes();
  }
  //=====================================================
  void saveDisplaying(ostream &os, DataSet &data) {
    os << "(displaying " << endl;
    Color colorVal;
    string colorList[] = {"backgroundColor"};
    for (int i=0; i<1; ++i) {
      if (data.get<Color>(colorList[i], colorVal)) {
	os << "(color \"" << colorList[i] << "\"";
	os << " \"(" << (int)colorVal.getR() << "," << (int)colorVal.getG() << "," << (int)colorVal.getB() << ",0)\")" << endl;
      }
    }
    bool boolVal;
    string boolList[] = {"_viewArrow", "_viewLabel", "_viewKey", "_viewStrahler",
			 "_viewAutoScale", "_incrementalRendering", "_edgeColorInterpolate", "_edge3D"};
    for (int i=0; i < 8; ++i) {
      if (data.get<bool>(boolList[i], boolVal))
	os << "(bool \"" << boolList[i] << "\" " << (boolVal ? "true" : "false") << ")" << endl;
    }
    unsigned int uintVal;
    string uintList[]={"_viewColorEntry", "_viewOrtho", "_FontsType" };
    for (int i=0; i<3; ++i) {
      if (data.get<unsigned int>(uintList[i], uintVal))
	  os << "(uint \"" << uintList[i] << "\" " << uintVal << ")" << endl;
    }
    int intVal;
    string intList[]={"SupergraphId"};
    for (int i=0; i<1; ++i) {
      if (data.get<int>(intList[i], intVal))
	os << "(int \"" << intList[i] << "\" " << intVal << ")" << endl;
    }
    Coord coordVal;
    string coordList[] = {"sceneTranslation", "sceneRotation", "cameraEyes", "cameraCenter", "cameraUp"};
    for (int i=0; i<5; ++i) {
      if (data.get<Coord>(coordList[i], coordVal)) {
	os << "(coord \"" << coordList[i] << "\"";
	os << " \"(" << coordVal.getX() << "," << coordVal.getY() << "," << coordVal.getZ() << ")\")" << endl;
      }
    }
    double doubleVal;
    if (data.get<double>("cameraZoomFactor", doubleVal)) {
      os << "(double \"cameraZoomFactor\" " << doubleVal << ")" << endl;
    }
    float floatVal;
    if (data.get<float>("distCam", floatVal)) {
      os << "(float \"distCam\" " << floatVal << ")" << endl;
    }
    os << ")" << endl;
  }
  
  bool exportGraph(ostream &os,SuperGraph *currentGraph) {
    superGraph=currentGraph->getRoot();
    if (dataSet != NULL) {
      dataSet->get<DataSet>("displaying", displaying);
    }

    saveGraphElements(os,superGraph);
    saveProperties(os,superGraph);

    //Save displaying
    //    DataSet displaying;
    if (dataSet->get<DataSet>("displaying", displaying))
      saveDisplaying(os, displaying);
    
    //os << ')' << endl;
    return true;
  }
};
/*@}*/
EXPORTPLUGIN(TLP,"tlp","Auber David","31/07/2001","0","1","0");
