#include <iostream>

#include <qevent.h>

#include <tulip/SuperGraph.h>
#include <tulip/GlGraphWidget.h>

#include "tulip/MouseZoomBox.h"

using namespace std;

MouseZoomBox::MouseZoomBox() : x(0), y(0), w(0), h(0), started(false), superGraph(0) {}
MouseZoomBox::~MouseZoomBox() {}

void MouseZoomBox::mPressEvent(GlGraphWidget *glw, QMouseEvent *qMouseEv) {
  if (qMouseEv->button() == QEvent::LeftButton) {
    if (!started) {
      x = qMouseEv->x();
      y =  glw->height() - qMouseEv->y();
      w = 0; h = 0;
      started = true;
      glw->setMouseTracking(true);
      superGraph = glw->getGlGraph()->getSuperGraph();
    }
    else {
      if (glw->getGlGraph()->getSuperGraph() != superGraph) {
	superGraph = NULL;
        started = false;
        glw->setMouseTracking(false);
      }
    }
  }

  if (qMouseEv->button()==QEvent::MidButton){
    started = false;
    glw->setMouseTracking(false);
    glw->UpdateGL();
  }
  
  if (qMouseEv->button()==QEvent::RightButton) {}
}

void MouseZoomBox::mReleaseEvent(GlGraphWidget *glw, QMouseEvent *qMouseEv){
  if (glw->getGlGraph()->getSuperGraph() != superGraph) {
    superGraph = NULL;
    started = false;
    glw->setMouseTracking(false);
  }
  
  if (started) {
    started = false;
    if ((abs(w) > 10) || (abs(h) > 10)) {
      //      cerr << __FUNCTION__ << ": " << this << "(x,y)=(" << e->x() << "," << e->y() << ")" << endl;
      GlGraph *glgraph = glw->getGlGraph();
      int width = glw->width();
      int height = glw->height();
      glgraph->translateCamera(width/2 - (x+w/2), height/2 - (y-h/2), 0);
      w = abs(w); h = abs(h);
      
      Camera cam = glw->getGlGraph()->getCamera();
      //we prevent zooming in a minimal square area less than 4x4: a least
      //one of the 2 lengths must be higher than 3
      
      if (w > h) {
        //          cerr << __FUNCTION__ << ": zoomFactor=" << cam.zoomFactor;
        cam.zoomFactor *= (double) width / (double) w;
        //          cerr << ", set to " << cam.zoomFactor << endl;
      }
      else {
        //          cerr << __FUNCTION__ << ": zoomFactor=" << cam.zoomFactor;
        cam.zoomFactor *= (double) height / (double) h;
        //          cerr << ", set to " << cam.zoomFactor << endl;
      }
      
      glw->getGlGraph()->setCamera(cam);
      glw->UpdateGL();
    }
    else {
      glw->clickAt(qMouseEv->pos());
    }
  }
  /*{
    started = false;
    glw->setMouseTracking(false);
    int width = glw->width();
    int height = glw->height();
    Observable::holdObservers();
    GlGraph *glgraph = glw->getGlGraph();
    glgraph->translateCamera(width/2 - (x+w/2), height/2 - (y-h/2), 0);
    w = abs(w); h = abs(h);

    if (w > h) {
      //      cerr << __FUNCTION__ << ": "
      glgraph->zoom(width / w);
    }
    else {
      glgraph->zoom(height / h);
    }
    
    glw->redraw();
    Observable::unholdObservers();
    }
  */
}

void MouseZoomBox::mMoveEvent(GlGraphWidget *glw, QMouseEvent *qMouseEv)
{
  if (glw->getGlGraph()->getSuperGraph() != superGraph) {
    superGraph = NULL;
    started = false;
    glw->setMouseTracking(false);
  }
  
  if (started){
    if ((qMouseEv->x() > 0) && (qMouseEv->x() < glw->width()))
      w = qMouseEv->x() - x;
    if ((qMouseEv->y() > 0) && (qMouseEv->y() < glw->height()))
      h = y - (glw->height() - qMouseEv->y());
    glw->UpdateGL();
  }
}

void MouseZoomBox::mPaint(GlGraphWidget *glw){
  if (glw->getGlGraph()->getSuperGraph() != superGraph) {
    superGraph = NULL;
    started = false;
    glw->setMouseTracking(false);
  }
  if (!started) return;
  glPushAttrib(GL_ALL_ATTRIB_BITS);
  glMatrixMode (GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  gluOrtho2D(0.0, (GLdouble)glw->width(), 0.0, (GLdouble)glw->height());
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  glDisable(GL_LIGHTING);
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_SRC_COLOR);
  
  float col[4] = {0.8, 0.4, 0.4, 0.2};
  glColor4fv(col);
  glBegin(GL_QUADS);
  glVertex2f(x, y);
  glVertex2f(x+w, y);
  glVertex2f(x+w, y-h);
  glVertex2f(x, y-h);
  glEnd();
  glDisable(GL_BLEND);
  
  glLineWidth(2);
  glLineStipple(2, 0xAAAA);
  glEnable(GL_LINE_STIPPLE);
  glBegin(GL_LINE_LOOP);
  glVertex2f(x, y);
  glVertex2f(x+w, y);
  glVertex2f(x+w, y-h);
  glVertex2f(x, y-h);
  glEnd();
  /*
  glLineWidth(1);
  glDisable(GL_LINE_STIPPLE);  
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);
  glEnable(GL_LIGHTING);
  */
  glPopMatrix();
  glMatrixMode (GL_PROJECTION);
  glPopMatrix();
  glMatrixMode (GL_MODELVIEW);
  glPopAttrib();
}

